/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.config;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.cassandra.config.xml.ParsingUtils;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.data.cassandra.repository.support.CassandraRepositoryFactoryBean;
import org.springframework.data.repository.config.AnnotationRepositoryConfigurationSource;
import org.springframework.data.repository.config.RepositoryConfigurationExtensionSupport;
import org.springframework.data.repository.config.XmlRepositoryConfigurationSource;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class CassandraRepositoryConfigurationExtension
extends RepositoryConfigurationExtensionSupport {
    private static final String CASSANDRA_TEMPLATE_REF = "cassandra-template-ref";

    protected String getModulePrefix() {
        return "cassandra";
    }

    public String getRepositoryFactoryClassName() {
        return CassandraRepositoryFactoryBean.class.getName();
    }

    public void postProcess(BeanDefinitionBuilder builder, XmlRepositoryConfigurationSource config) {
        Element element = config.getElement();
        ParsingUtils.addOptionalPropertyReference((BeanDefinitionBuilder)builder, (String)"cassandraTemplate", (Element)element, (String)CASSANDRA_TEMPLATE_REF, (String)"cqlTemplate");
    }

    public void postProcess(BeanDefinitionBuilder builder, AnnotationRepositoryConfigurationSource config) {
        AnnotationAttributes attributes = config.getAttributes();
        String cassandraTemplateRef = attributes.getString("cassandraTemplateRef");
        if (StringUtils.hasText((String)cassandraTemplateRef)) {
            builder.addPropertyReference("cassandraTemplate", cassandraTemplateRef);
        }
    }
}

