/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.config.xml;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.cassandra.config.xml.CassandraMappingXmlBeanFactoryPostProcessorRegistrar;
import org.springframework.data.cassandra.mapping.BasicCassandraMappingContext;
import org.springframework.data.cassandra.mapping.EntityMapping;
import org.springframework.data.cassandra.mapping.Mapping;
import org.springframework.data.cassandra.mapping.PropertyMapping;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class CassandraMappingContextParser
extends AbstractSingleBeanDefinitionParser {
    protected Class<?> getBeanClass(Element element) {
        return BasicCassandraMappingContext.class;
    }

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        String id = super.resolveId(element, definition, parserContext);
        return StringUtils.hasText((String)id) ? id : "cassandraMapping";
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        CassandraMappingXmlBeanFactoryPostProcessorRegistrar.ensureRegistration(element, parserContext);
        this.parseMapping(element, builder);
    }

    protected void parseMapping(Element element, BeanDefinitionBuilder builder) {
        HashSet<EntityMapping> mappings = new HashSet<EntityMapping>();
        for (Element entity : DomUtils.getChildElementsByTagName((Element)element, (String)"entity")) {
            EntityMapping entityMapping = this.parseEntity(entity);
            if (entityMapping == null) continue;
            mappings.add(entityMapping);
        }
        Mapping mapping = new Mapping();
        mapping.setEntityMappings(mappings);
        builder.addPropertyValue("mapping", (Object)mapping);
    }

    protected EntityMapping parseEntity(Element entity) {
        String className = entity.getAttribute("class");
        if (!StringUtils.hasText((String)className)) {
            throw new IllegalStateException("class attribute must not be empty");
        }
        String tableName = "";
        String forceQuote = "";
        Element table = DomUtils.getChildElementByTagName((Element)entity, (String)"table");
        if (table != null) {
            tableName = table.getAttribute("name");
            if (!StringUtils.hasText((String)tableName)) {
                tableName = "";
            }
            if (!StringUtils.hasText((String)(forceQuote = table.getAttribute("force-quote")))) {
                forceQuote = Boolean.FALSE.toString();
            }
        }
        Map<String, PropertyMapping> propertyMappings = this.parsePropertyMappings(entity);
        EntityMapping entityMapping = new EntityMapping(className, tableName, forceQuote);
        entityMapping.setPropertyMappings(propertyMappings);
        return entityMapping;
    }

    protected Map<String, PropertyMapping> parsePropertyMappings(Element entity) {
        HashMap<String, PropertyMapping> pms = new HashMap<String, PropertyMapping>();
        for (Element property : DomUtils.getChildElementsByTagName((Element)entity, (String)"property")) {
            String value = property.getAttribute("name");
            if (!StringUtils.hasText((String)value)) {
                throw new IllegalStateException("name attribute must not be empty");
            }
            PropertyMapping pm = new PropertyMapping(value);
            value = property.getAttribute("column-name");
            if (StringUtils.hasText((String)value)) {
                pm.setColumnName(value);
            }
            if (StringUtils.hasText((String)(value = property.getAttribute("force-quote")))) {
                pm.setForceQuote(value);
            }
            pms.put(pm.getPropertyName(), pm);
        }
        return pms;
    }
}

