/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cassandra.core.converter;

import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.Row;
import java.util.HashMap;
import java.util.Map;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.ReadingConverter;

@ReadingConverter
public class RowToMapConverter
implements Converter<Row, Map<String, Object>> {
    public static final RowToMapConverter INSTANCE = new RowToMapConverter();

    public Map<String, Object> convert(Row row) {
        if (row == null) {
            return null;
        }
        ColumnDefinitions cols = row.getColumnDefinitions();
        HashMap<String, Object> map = new HashMap<String, Object>(cols.size());
        for (ColumnDefinitions.Definition def : cols.asList()) {
            String name;
            map.put(name, row.isNull(name = def.getName()) ? null : row.getObject(name));
        }
        return map;
    }
}

