/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cassandra.config;

import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.PoolingOptions;
import java.lang.reflect.Method;
import java.util.concurrent.Executor;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.ReflectionUtils;

public class PoolingOptionsFactoryBean
implements FactoryBean<PoolingOptions>,
InitializingBean {
    private static final PoolingOptions DEFAULT = new PoolingOptions();
    private static final Method SET_MAX_QUEUE_SIZE = ReflectionUtils.findMethod(PoolingOptions.class, (String)"setMaxQueueSize", (Class[])new Class[]{Integer.TYPE});
    private static final Method GET_MAX_QUEUE_SIZE = ReflectionUtils.findMethod(PoolingOptions.class, (String)"getMaxQueueSize");
    private Executor initializationExecutor;
    private int heartbeatIntervalSeconds;
    private int idleTimeoutSeconds;
    private Integer localCoreConnections;
    private Integer localMaxConnections;
    private Integer localMaxSimultaneousRequests;
    private Integer localMinSimultaneousRequests;
    private int poolTimeoutMilliseconds;
    private int maxQueueSize;
    private Integer remoteCoreConnections;
    private Integer remoteMaxConnections;
    private Integer remoteMaxSimultaneousRequests;
    private Integer remoteMinSimultaneousRequests;
    private PoolingOptions poolingOptions;

    public void afterPropertiesSet() throws Exception {
        this.poolingOptions = this.configureRemoteHostDistancePoolingOptions(this.configureLocalHostDistancePoolingOptions(this.newPoolingOptions()));
        if (this.heartbeatIntervalSeconds != DEFAULT.getHeartbeatIntervalSeconds()) {
            this.poolingOptions.setHeartbeatIntervalSeconds(this.heartbeatIntervalSeconds);
        }
        if (this.idleTimeoutSeconds != DEFAULT.getIdleTimeoutSeconds()) {
            this.poolingOptions.setIdleTimeoutSeconds(this.idleTimeoutSeconds);
        }
        if (this.initializationExecutor != null) {
            this.poolingOptions.setInitializationExecutor(this.initializationExecutor);
        }
        if (this.poolTimeoutMilliseconds != DEFAULT.getPoolTimeoutMillis()) {
            this.poolingOptions.setPoolTimeoutMillis(this.poolTimeoutMilliseconds);
        }
        if (!this.isDefaultMaxQueueSize() && SET_MAX_QUEUE_SIZE != null) {
            ReflectionUtils.invokeMethod((Method)SET_MAX_QUEUE_SIZE, (Object)this.poolingOptions, (Object[])new Object[]{this.maxQueueSize});
        }
    }

    private boolean isDefaultMaxQueueSize() {
        Integer defaultMaxQueueSize;
        return GET_MAX_QUEUE_SIZE != null && (defaultMaxQueueSize = (Integer)ReflectionUtils.invokeMethod((Method)GET_MAX_QUEUE_SIZE, (Object)this.poolingOptions)) == this.maxQueueSize;
    }

    PoolingOptions newPoolingOptions() {
        return new PoolingOptions();
    }

    protected HostDistancePoolingOptions newLocalHostDistancePoolingOptions() {
        return LocalHostDistancePoolingOptions.create(this.getLocalCoreConnections(), this.getLocalMaxConnections(), this.getLocalMaxSimultaneousRequests(), this.getLocalMinSimultaneousRequests());
    }

    protected HostDistancePoolingOptions newRemoteHostDistancePoolingOptions() {
        return RemoteHostDistancePoolingOptions.create(this.getRemoteCoreConnections(), this.getRemoteMaxConnections(), this.getRemoteMaxSimultaneousRequests(), this.getRemoteMinSimultaneousRequests());
    }

    protected PoolingOptions configureLocalHostDistancePoolingOptions(PoolingOptions poolingOptions) {
        return this.newLocalHostDistancePoolingOptions().configure(poolingOptions);
    }

    protected PoolingOptions configureRemoteHostDistancePoolingOptions(PoolingOptions poolingOptions) {
        return this.newRemoteHostDistancePoolingOptions().configure(poolingOptions);
    }

    public PoolingOptions getObject() throws Exception {
        return this.poolingOptions;
    }

    public Class<?> getObjectType() {
        return this.poolingOptions != null ? this.poolingOptions.getClass() : PoolingOptions.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setHeartbeatIntervalSeconds(int heartbeatIntervalSeconds) {
        this.heartbeatIntervalSeconds = heartbeatIntervalSeconds;
    }

    public int getHeartbeatIntervalSeconds() {
        return this.heartbeatIntervalSeconds;
    }

    public void setIdleTimeoutSeconds(int idleTimeoutSeconds) {
        this.idleTimeoutSeconds = idleTimeoutSeconds;
    }

    public int getIdleTimeoutSeconds() {
        return this.idleTimeoutSeconds;
    }

    public void setInitializationExecutor(Executor initializationExecutor) {
        this.initializationExecutor = initializationExecutor;
    }

    public Executor getInitializationExecutor() {
        return this.initializationExecutor;
    }

    public void setPoolTimeoutMilliseconds(int poolTimeoutMilliseconds) {
        this.poolTimeoutMilliseconds = poolTimeoutMilliseconds;
    }

    public int getPoolTimeoutMilliseconds() {
        return this.poolTimeoutMilliseconds;
    }

    public void setMaxQueueSize(Integer maxQueueSize) {
        this.maxQueueSize = maxQueueSize;
    }

    public Integer getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public void setLocalCoreConnections(Integer localCoreConnections) {
        this.localCoreConnections = localCoreConnections;
    }

    public Integer getLocalCoreConnections() {
        return this.localCoreConnections;
    }

    public void setLocalMaxConnections(Integer localMaxConnections) {
        this.localMaxConnections = localMaxConnections;
    }

    public Integer getLocalMaxConnections() {
        return this.localMaxConnections;
    }

    public void setLocalMaxSimultaneousRequests(Integer localMaxSimultaneousRequests) {
        this.localMaxSimultaneousRequests = localMaxSimultaneousRequests;
    }

    public Integer getLocalMaxSimultaneousRequests() {
        return this.localMaxSimultaneousRequests;
    }

    public void setLocalMinSimultaneousRequests(Integer localMinSimultaneousRequests) {
        this.localMinSimultaneousRequests = localMinSimultaneousRequests;
    }

    public Integer getLocalMinSimultaneousRequests() {
        return this.localMinSimultaneousRequests;
    }

    public void setRemoteCoreConnections(Integer remoteCoreConnections) {
        this.remoteCoreConnections = remoteCoreConnections;
    }

    public Integer getRemoteCoreConnections() {
        return this.remoteCoreConnections;
    }

    public void setRemoteMaxConnections(Integer remoteMaxConnections) {
        this.remoteMaxConnections = remoteMaxConnections;
    }

    public Integer getRemoteMaxConnections() {
        return this.remoteMaxConnections;
    }

    public void setRemoteMaxSimultaneousRequests(Integer remoteMaxSimultaneousRequests) {
        this.remoteMaxSimultaneousRequests = remoteMaxSimultaneousRequests;
    }

    public Integer getRemoteMaxSimultaneousRequests() {
        return this.remoteMaxSimultaneousRequests;
    }

    public void setRemoteMinSimultaneousRequests(Integer remoteMinSimultaneousRequests) {
        this.remoteMinSimultaneousRequests = remoteMinSimultaneousRequests;
    }

    public Integer getRemoteMinSimultaneousRequests() {
        return this.remoteMinSimultaneousRequests;
    }

    static class RemoteHostDistancePoolingOptions
    extends HostDistancePoolingOptions {
        static RemoteHostDistancePoolingOptions create(Integer coreConnectionsPerHost, Integer maxConnectionsPerHost, Integer maxRequestsPerConnection, Integer newConnectionThreshold) {
            return new RemoteHostDistancePoolingOptions(coreConnectionsPerHost, maxConnectionsPerHost, maxRequestsPerConnection, newConnectionThreshold);
        }

        RemoteHostDistancePoolingOptions(Integer coreConnectionsPerHost, Integer maxConnectionsPerHost, Integer maxRequestsPerConnection, Integer newConnectionThreshold) {
            super(coreConnectionsPerHost, maxConnectionsPerHost, maxRequestsPerConnection, newConnectionThreshold);
        }

        @Override
        protected HostDistance getHostDistance() {
            return HostDistance.REMOTE;
        }
    }

    static class LocalHostDistancePoolingOptions
    extends HostDistancePoolingOptions {
        static LocalHostDistancePoolingOptions create(Integer coreConnectionsPerHost, Integer maxConnectionsPerHost, Integer maxRequestsPerConnection, Integer newConnectionThreshold) {
            return new LocalHostDistancePoolingOptions(coreConnectionsPerHost, maxConnectionsPerHost, maxRequestsPerConnection, newConnectionThreshold);
        }

        LocalHostDistancePoolingOptions(Integer coreConnectionsPerHost, Integer maxConnectionsPerHost, Integer maxRequestsPerConnection, Integer newConnectionThreshold) {
            super(coreConnectionsPerHost, maxConnectionsPerHost, maxRequestsPerConnection, newConnectionThreshold);
        }

        @Override
        protected HostDistance getHostDistance() {
            return HostDistance.LOCAL;
        }
    }

    protected static abstract class HostDistancePoolingOptions {
        private final Integer coreConnectionsPerHost;
        private final Integer maxConnectionsPerHost;
        private final Integer maxRequestsPerConnection;
        private final Integer newConnectionThreshold;

        protected HostDistancePoolingOptions(Integer coreConnectionsPerHost, Integer maxConnectionsPerHost, Integer maxRequestsPerConnection, Integer newConnectionThreshold) {
            this.coreConnectionsPerHost = coreConnectionsPerHost;
            this.maxConnectionsPerHost = maxConnectionsPerHost;
            this.maxRequestsPerConnection = maxRequestsPerConnection;
            this.newConnectionThreshold = newConnectionThreshold;
        }

        protected abstract HostDistance getHostDistance();

        PoolingOptions setCoreConnectionsPerHost(PoolingOptions poolingOptions) {
            if (this.coreConnectionsPerHost != null) {
                poolingOptions.setCoreConnectionsPerHost(this.getHostDistance(), this.coreConnectionsPerHost.intValue());
            }
            return poolingOptions;
        }

        protected Integer getCoreConnectionsPerHost() {
            return this.coreConnectionsPerHost;
        }

        PoolingOptions setMaxConnectionsPerHost(PoolingOptions poolingOptions) {
            if (this.maxConnectionsPerHost != null) {
                poolingOptions.setMaxConnectionsPerHost(this.getHostDistance(), this.maxConnectionsPerHost.intValue());
            }
            return poolingOptions;
        }

        protected Integer getMaxConnectionsPerHost() {
            return this.maxConnectionsPerHost;
        }

        PoolingOptions setMaxRequestsPerConnection(PoolingOptions poolingOptions) {
            if (this.maxRequestsPerConnection != null) {
                poolingOptions.setMaxRequestsPerConnection(this.getHostDistance(), this.maxRequestsPerConnection.intValue());
            }
            return poolingOptions;
        }

        protected Integer getMaxRequestsPerConnection() {
            return this.maxRequestsPerConnection;
        }

        PoolingOptions setNewConnectionThreshold(PoolingOptions poolingOptions) {
            int currentNewConnectionThreshold;
            if (this.newConnectionThreshold != null && (currentNewConnectionThreshold = poolingOptions.getNewConnectionThreshold(this.getHostDistance())) < this.newConnectionThreshold) {
                poolingOptions.setNewConnectionThreshold(this.getHostDistance(), this.newConnectionThreshold.intValue());
            }
            return poolingOptions;
        }

        protected Integer getNewConnectionThreshold() {
            return this.newConnectionThreshold;
        }

        PoolingOptions configure(PoolingOptions poolingOptions) {
            this.setMaxConnectionsPerHost(poolingOptions);
            this.setCoreConnectionsPerHost(poolingOptions);
            this.setMaxRequestsPerConnection(poolingOptions);
            this.setNewConnectionThreshold(poolingOptions);
            return poolingOptions;
        }
    }
}

