/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cassandra.core;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.core.querybuilder.Batch;
import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.datastax.driver.core.querybuilder.Truncate;
import com.datastax.driver.core.querybuilder.Update;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cassandra.core.AsynchronousQueryListener;
import org.springframework.cassandra.core.CachedPreparedStatementCreator;
import org.springframework.cassandra.core.Cancellable;
import org.springframework.cassandra.core.CassandraUncategorizedDataAccessException;
import org.springframework.cassandra.core.ConsistencyLevelResolver;
import org.springframework.cassandra.core.CqlOperations;
import org.springframework.cassandra.core.HostMapper;
import org.springframework.cassandra.core.PreparedStatementBinder;
import org.springframework.cassandra.core.PreparedStatementCallback;
import org.springframework.cassandra.core.PreparedStatementCreator;
import org.springframework.cassandra.core.QueryForListListener;
import org.springframework.cassandra.core.QueryForMapListener;
import org.springframework.cassandra.core.QueryForObjectListener;
import org.springframework.cassandra.core.QueryOptions;
import org.springframework.cassandra.core.ResultSetExtractor;
import org.springframework.cassandra.core.ResultSetFutureCancellable;
import org.springframework.cassandra.core.ResultSetFutureExtractor;
import org.springframework.cassandra.core.RetryPolicyResolver;
import org.springframework.cassandra.core.RingMember;
import org.springframework.cassandra.core.RingMemberHostMapper;
import org.springframework.cassandra.core.RowCallbackHandler;
import org.springframework.cassandra.core.RowIterator;
import org.springframework.cassandra.core.RowMapper;
import org.springframework.cassandra.core.SessionCallback;
import org.springframework.cassandra.core.WriteOptions;
import org.springframework.cassandra.core.cql.CqlIdentifier;
import org.springframework.cassandra.core.cql.generator.AlterKeyspaceCqlGenerator;
import org.springframework.cassandra.core.cql.generator.AlterTableCqlGenerator;
import org.springframework.cassandra.core.cql.generator.CreateIndexCqlGenerator;
import org.springframework.cassandra.core.cql.generator.CreateKeyspaceCqlGenerator;
import org.springframework.cassandra.core.cql.generator.CreateTableCqlGenerator;
import org.springframework.cassandra.core.cql.generator.DropIndexCqlGenerator;
import org.springframework.cassandra.core.cql.generator.DropKeyspaceCqlGenerator;
import org.springframework.cassandra.core.cql.generator.DropTableCqlGenerator;
import org.springframework.cassandra.core.keyspace.AlterKeyspaceSpecification;
import org.springframework.cassandra.core.keyspace.AlterTableSpecification;
import org.springframework.cassandra.core.keyspace.CreateIndexSpecification;
import org.springframework.cassandra.core.keyspace.CreateKeyspaceSpecification;
import org.springframework.cassandra.core.keyspace.CreateTableSpecification;
import org.springframework.cassandra.core.keyspace.DropIndexSpecification;
import org.springframework.cassandra.core.keyspace.DropKeyspaceSpecification;
import org.springframework.cassandra.core.keyspace.DropTableSpecification;
import org.springframework.cassandra.support.CassandraAccessor;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.dao.QueryTimeoutException;
import org.springframework.util.Assert;

public class CqlTemplate
extends CassandraAccessor
implements CqlOperations {
    protected static final Logger log = LoggerFactory.getLogger(CqlTemplate.class);

    public static Statement addQueryOptions(Statement q, QueryOptions options) {
        if (options == null) {
            return q;
        }
        if (options.getConsistencyLevel() != null) {
            q.setConsistencyLevel(ConsistencyLevelResolver.resolve(options.getConsistencyLevel()));
        }
        if (options.getRetryPolicy() != null) {
            q.setRetryPolicy(RetryPolicyResolver.resolve(options.getRetryPolicy()));
        }
        return q;
    }

    public static Insert addWriteOptions(Insert q, WriteOptions options) {
        if (options == null) {
            return q;
        }
        if (options.getConsistencyLevel() != null) {
            q.setConsistencyLevel(ConsistencyLevelResolver.resolve(options.getConsistencyLevel()));
        }
        if (options.getRetryPolicy() != null) {
            q.setRetryPolicy(RetryPolicyResolver.resolve(options.getRetryPolicy()));
        }
        if (options.getTtl() != null) {
            q.using(QueryBuilder.ttl((int)options.getTtl()));
        }
        return q;
    }

    public static Update addWriteOptions(Update q, WriteOptions options) {
        if (options == null) {
            return q;
        }
        if (options.getConsistencyLevel() != null) {
            q.setConsistencyLevel(ConsistencyLevelResolver.resolve(options.getConsistencyLevel()));
        }
        if (options.getRetryPolicy() != null) {
            q.setRetryPolicy(RetryPolicyResolver.resolve(options.getRetryPolicy()));
        }
        if (options.getTtl() != null) {
            q.using(QueryBuilder.ttl((int)options.getTtl()));
        }
        return q;
    }

    public static void addPreparedStatementOptions(PreparedStatement s, QueryOptions options) {
        if (options == null) {
            return;
        }
        if (options.getConsistencyLevel() != null) {
            s.setConsistencyLevel(ConsistencyLevelResolver.resolve(options.getConsistencyLevel()));
        }
        if (options.getRetryPolicy() != null) {
            s.setRetryPolicy(RetryPolicyResolver.resolve(options.getRetryPolicy()));
        }
    }

    public CqlTemplate() {
    }

    public CqlTemplate(Session session) {
        this.setSession(session);
    }

    @Override
    public <T> T execute(SessionCallback<T> sessionCallback) throws DataAccessException {
        return this.doExecute(sessionCallback);
    }

    @Override
    public void execute(String cql) throws DataAccessException {
        this.execute(cql, (QueryOptions)null);
    }

    @Override
    public void execute(String cql, QueryOptions options) throws DataAccessException {
        this.doExecute(cql, options);
    }

    @Override
    public void execute(Statement query) throws DataAccessException {
        this.doExecute(query);
    }

    @Override
    public ResultSetFuture queryAsynchronously(final String cql) {
        return this.execute(new SessionCallback<ResultSetFuture>(){

            @Override
            public ResultSetFuture doInSession(Session s) throws DataAccessException {
                return s.executeAsync(cql);
            }
        });
    }

    @Override
    public <T> T queryAsynchronously(String cql, ResultSetExtractor<T> rse, Long timeout, TimeUnit timeUnit) {
        return this.queryAsynchronously(cql, rse, timeout, timeUnit, null);
    }

    @Override
    public <T> T queryAsynchronously(final String cql, ResultSetExtractor<T> rse, final Long timeout, final TimeUnit timeUnit, final QueryOptions options) {
        return rse.extractData(this.execute(new SessionCallback<ResultSet>(){

            @Override
            public ResultSet doInSession(Session s) throws DataAccessException {
                SimpleStatement statement = new SimpleStatement(cql);
                CqlTemplate.addQueryOptions((Statement)statement, options);
                ResultSetFuture rsf = s.executeAsync((Statement)statement);
                ResultSet rs = null;
                try {
                    rs = (ResultSet)rsf.get(timeout.longValue(), timeUnit);
                }
                catch (TimeoutException e) {
                    throw new QueryTimeoutException("Asyncronous Query Timed Out.", (Throwable)e);
                }
                catch (InterruptedException e) {
                    throw CqlTemplate.this.translateExceptionIfPossible(e);
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof Exception) {
                        throw CqlTemplate.this.translateExceptionIfPossible((Exception)e.getCause());
                    }
                    throw new CassandraUncategorizedDataAccessException("Unknown Throwable", e.getCause());
                }
                return rs;
            }
        }));
    }

    @Override
    public ResultSetFuture queryAsynchronously(final String cql, final QueryOptions options) {
        return this.execute(new SessionCallback<ResultSetFuture>(){

            @Override
            public ResultSetFuture doInSession(Session s) throws DataAccessException {
                SimpleStatement statement = new SimpleStatement(cql);
                CqlTemplate.addQueryOptions((Statement)statement, options);
                return s.executeAsync((Statement)statement);
            }
        });
    }

    @Override
    public Cancellable queryAsynchronously(String cql, Runnable listener) {
        return this.queryAsynchronously(cql, listener, new Executor(){

            @Override
            public void execute(Runnable command) {
                command.run();
            }
        });
    }

    @Override
    public Cancellable queryAsynchronously(String cql, AsynchronousQueryListener listener) {
        return this.queryAsynchronously(cql, listener, new Executor(){

            @Override
            public void execute(Runnable command) {
                command.run();
            }
        });
    }

    @Override
    public Cancellable queryAsynchronously(String cql, Runnable listener, QueryOptions options) {
        return this.queryAsynchronously(cql, listener, options, new Executor(){

            @Override
            public void execute(Runnable command) {
                command.run();
            }
        });
    }

    @Override
    public Cancellable queryAsynchronously(String cql, AsynchronousQueryListener listener, QueryOptions options) {
        return this.queryAsynchronously(cql, listener, options, new Executor(){

            @Override
            public void execute(Runnable command) {
                command.run();
            }
        });
    }

    @Override
    public Cancellable queryAsynchronously(String cql, Runnable listener, Executor executor) {
        return this.queryAsynchronously(cql, listener, null, executor);
    }

    @Override
    public Cancellable queryAsynchronously(String cql, AsynchronousQueryListener listener, Executor executor) {
        return this.queryAsynchronously(cql, listener, null, executor);
    }

    @Override
    public Cancellable queryAsynchronously(final String cql, final Runnable listener, final QueryOptions options, final Executor executor) {
        return this.execute(new SessionCallback<Cancellable>(){

            @Override
            public Cancellable doInSession(Session s) throws DataAccessException {
                SimpleStatement statement = new SimpleStatement(cql);
                CqlTemplate.addQueryOptions((Statement)statement, options);
                ResultSetFuture rsf = s.executeAsync((Statement)statement);
                rsf.addListener(listener, executor);
                return new ResultSetFutureCancellable(rsf);
            }
        });
    }

    @Override
    public Cancellable queryAsynchronously(final String cql, final AsynchronousQueryListener listener, final QueryOptions options, final Executor executor) {
        return this.execute(new SessionCallback<Cancellable>(){

            @Override
            public Cancellable doInSession(Session s) throws DataAccessException {
                SimpleStatement statement = new SimpleStatement(cql);
                CqlTemplate.addQueryOptions((Statement)statement, options);
                final ResultSetFuture rsf = s.executeAsync((Statement)statement);
                Runnable wrapper = new Runnable(){

                    @Override
                    public void run() {
                        listener.onQueryComplete(rsf);
                    }
                };
                rsf.addListener(wrapper, executor);
                return new ResultSetFutureCancellable(rsf);
            }
        });
    }

    public <T> T queryAsynchronously(final String cql, ResultSetFutureExtractor<T> rse, final QueryOptions options) throws DataAccessException {
        return rse.extractData(this.execute(new SessionCallback<ResultSetFuture>(){

            @Override
            public ResultSetFuture doInSession(Session s) throws DataAccessException {
                SimpleStatement statement = new SimpleStatement(cql);
                CqlTemplate.addQueryOptions((Statement)statement, options);
                return s.executeAsync((Statement)statement);
            }
        }));
    }

    public <T> T queryAsynchronously(String cql, ResultSetFutureExtractor<T> rse) throws DataAccessException {
        return this.queryAsynchronously(cql, rse, null);
    }

    @Override
    public <T> T query(String cql, ResultSetExtractor<T> rse) throws DataAccessException {
        return this.query(cql, rse, null);
    }

    @Override
    public <T> T query(String cql, ResultSetExtractor<T> rse, QueryOptions options) throws DataAccessException {
        Assert.notNull((Object)cql);
        ResultSet rs = this.doExecute(cql, options);
        return rse.extractData(rs);
    }

    @Override
    public void query(String cql, RowCallbackHandler rch, QueryOptions options) throws DataAccessException {
        this.process(this.doExecute(cql, options), rch);
    }

    @Override
    public void query(String cql, RowCallbackHandler rch) throws DataAccessException {
        this.query(cql, rch, null);
    }

    @Override
    public <T> List<T> query(String cql, RowMapper<T> rowMapper, QueryOptions options) throws DataAccessException {
        return this.process(this.doExecute(cql, options), rowMapper);
    }

    @Override
    public ResultSet query(String cql) {
        return this.query(cql, (QueryOptions)null);
    }

    @Override
    public ResultSet query(String cql, QueryOptions options) {
        return this.query(cql, new ResultSetExtractor<ResultSet>(){

            @Override
            public ResultSet extractData(ResultSet rs) throws DriverException, DataAccessException {
                return rs;
            }
        }, options);
    }

    @Override
    public <T> List<T> query(String cql, RowMapper<T> rowMapper) throws DataAccessException {
        return this.query(cql, rowMapper, null);
    }

    @Override
    public List<Map<String, Object>> queryForListOfMap(String cql) throws DataAccessException {
        return this.processListOfMap(this.doExecute(cql, null));
    }

    @Override
    public <T> List<T> queryForList(String cql, Class<T> elementType) throws DataAccessException {
        return this.processList(this.doExecute(cql, null), elementType);
    }

    @Override
    public Map<String, Object> queryForMap(String cql) throws DataAccessException {
        return this.processMap(this.doExecute(cql, null));
    }

    @Override
    public <T> T queryForObject(String cql, Class<T> requiredType) throws DataAccessException {
        return this.processOne(this.doExecute(cql, null), requiredType);
    }

    @Override
    public <T> T queryForObject(String cql, RowMapper<T> rowMapper) throws DataAccessException {
        return this.processOne(this.doExecute(cql, null), rowMapper);
    }

    protected <T> T doExecute(SessionCallback<T> callback) {
        Assert.notNull(callback);
        try {
            return callback.doInSession(this.getSession());
        }
        catch (DataAccessException e) {
            throw this.translateExceptionIfPossible((RuntimeException)((Object)e));
        }
    }

    protected ResultSet doExecute(String cql) {
        return this.doExecute(cql, null);
    }

    protected ResultSet doExecute(String cql, QueryOptions options) {
        return this.doExecute(CqlTemplate.addQueryOptions((Statement)new SimpleStatement(cql), options));
    }

    protected ResultSet doExecute(final Statement q) {
        return this.doExecute(new SessionCallback<ResultSet>(){

            @Override
            public ResultSet doInSession(Session s) throws DataAccessException {
                if (log.isDebugEnabled()) {
                    log.debug("executing [{}]", (Object)q.toString());
                }
                return s.execute(q);
            }
        });
    }

    protected ResultSetFuture doExecuteAsync(final Statement q) {
        return this.doExecute(new SessionCallback<ResultSetFuture>(){

            @Override
            public ResultSetFuture doInSession(Session s) throws DataAccessException {
                if (log.isDebugEnabled()) {
                    log.debug("asynchronously executing [{}]", (Object)q.toString());
                }
                return s.executeAsync(q);
            }
        });
    }

    protected Cancellable doExecuteAsync(Statement q, AsynchronousQueryListener listener) {
        return this.doExecuteAsync(q, listener, null);
    }

    protected Cancellable doExecuteAsync(final Statement q, final AsynchronousQueryListener listener, final QueryOptions options) {
        return this.doExecute(new SessionCallback<Cancellable>(){

            @Override
            public Cancellable doInSession(Session s) throws DataAccessException {
                if (log.isDebugEnabled()) {
                    log.debug("asynchronously executing [{}]", (Object)q.toString());
                }
                if (options != null) {
                    CqlTemplate.addQueryOptions(q, options);
                }
                final ResultSetFuture rsf = s.executeAsync(q);
                if (listener != null) {
                    rsf.addListener(new Runnable(){

                        @Override
                        public void run() {
                            listener.onQueryComplete(rsf);
                        }
                    }, new Executor(){

                        @Override
                        public void execute(Runnable command) {
                            command.run();
                        }
                    });
                }
                return new ResultSetFutureCancellable(rsf);
            }
        });
    }

    protected Object firstColumnToObject(Row row) {
        ColumnDefinitions cols = row.getColumnDefinitions();
        if (cols.size() == 0) {
            return null;
        }
        return cols.getType(0).deserialize(row.getBytesUnsafe(0), ProtocolVersion.NEWEST_SUPPORTED);
    }

    protected Map<String, Object> toMap(Row row) {
        if (row == null) {
            return null;
        }
        ColumnDefinitions cols = row.getColumnDefinitions();
        HashMap<String, Object> map = new HashMap<String, Object>(cols.size());
        for (ColumnDefinitions.Definition def : cols.asList()) {
            String name = def.getName();
            map.put(name, def.getType().deserialize(row.getBytesUnsafe(name), ProtocolVersion.NEWEST_SUPPORTED));
        }
        return map;
    }

    @Override
    public List<RingMember> describeRing() throws DataAccessException {
        return new ArrayList<RingMember>(this.describeRing(new RingMemberHostMapper()));
    }

    protected Set<Host> getHosts() {
        return this.doExecute(new SessionCallback<Set<Host>>(){

            @Override
            public Set<Host> doInSession(Session s) throws DataAccessException {
                return s.getCluster().getMetadata().getAllHosts();
            }
        });
    }

    @Override
    public <T> Collection<T> describeRing(HostMapper<T> hostMapper) throws DataAccessException {
        Set<Host> hosts = this.getHosts();
        return hostMapper.mapHosts(hosts);
    }

    @Override
    public ResultSetFuture executeAsynchronously(String cql) throws DataAccessException {
        return this.executeAsynchronously(cql, (QueryOptions)null);
    }

    @Override
    public ResultSetFuture executeAsynchronously(String cql, QueryOptions options) throws DataAccessException {
        return this.doExecuteAsync(CqlTemplate.addQueryOptions((Statement)new SimpleStatement(cql), options));
    }

    @Override
    public Cancellable executeAsynchronously(String cql, Runnable listener) throws DataAccessException {
        return this.executeAsynchronously(cql, listener, new Executor(){

            @Override
            public void execute(Runnable command) {
                command.run();
            }
        });
    }

    @Override
    public Cancellable executeAsynchronously(final String cql, final Runnable listener, final Executor executor) throws DataAccessException {
        return this.execute(new SessionCallback<Cancellable>(){

            @Override
            public Cancellable doInSession(Session s) throws DataAccessException {
                SimpleStatement statement = new SimpleStatement(cql);
                ResultSetFuture rsf = s.executeAsync((Statement)statement);
                rsf.addListener(listener, executor);
                return new ResultSetFutureCancellable(rsf);
            }
        });
    }

    @Override
    public Cancellable executeAsynchronously(String cql, AsynchronousQueryListener listener) throws DataAccessException {
        return this.executeAsynchronously(cql, listener, new Executor(){

            @Override
            public void execute(Runnable command) {
                command.run();
            }
        });
    }

    @Override
    public Cancellable executeAsynchronously(final String cql, final AsynchronousQueryListener listener, final Executor executor) throws DataAccessException {
        return this.execute(new SessionCallback<Cancellable>(){

            @Override
            public Cancellable doInSession(Session s) throws DataAccessException {
                SimpleStatement statement = new SimpleStatement(cql);
                final ResultSetFuture rsf = s.executeAsync((Statement)statement);
                Runnable wrapper = new Runnable(){

                    @Override
                    public void run() {
                        listener.onQueryComplete(rsf);
                    }
                };
                rsf.addListener(wrapper, executor);
                return new ResultSetFutureCancellable(rsf);
            }
        });
    }

    @Override
    public ResultSetFuture executeAsynchronously(Statement query) throws DataAccessException {
        return this.doExecuteAsync(query);
    }

    @Override
    public Cancellable executeAsynchronously(Statement query, Runnable listener) throws DataAccessException {
        return this.executeAsynchronously(query, listener, new Executor(){

            @Override
            public void execute(Runnable command) {
                command.run();
            }
        });
    }

    @Override
    public Cancellable executeAsynchronously(Statement query, AsynchronousQueryListener listener) throws DataAccessException {
        return this.executeAsynchronously(query, listener, new Executor(){

            @Override
            public void execute(Runnable command) {
                command.run();
            }
        });
    }

    @Override
    public Cancellable executeAsynchronously(final Statement query, final Runnable listener, final Executor executor) throws DataAccessException {
        return this.execute(new SessionCallback<Cancellable>(){

            @Override
            public Cancellable doInSession(Session s) throws DataAccessException {
                ResultSetFuture rsf = s.executeAsync(query);
                rsf.addListener(listener, executor);
                return new ResultSetFutureCancellable(rsf);
            }
        });
    }

    @Override
    public Cancellable executeAsynchronously(final Statement query, final AsynchronousQueryListener listener, final Executor executor) throws DataAccessException {
        return this.execute(new SessionCallback<Cancellable>(){

            @Override
            public Cancellable doInSession(Session s) throws DataAccessException {
                final ResultSetFuture rsf = s.executeAsync(query);
                if (listener != null) {
                    Runnable wrapper = new Runnable(){

                        @Override
                        public void run() {
                            listener.onQueryComplete(rsf);
                        }
                    };
                    rsf.addListener(wrapper, executor);
                }
                return new ResultSetFutureCancellable(rsf);
            }
        });
    }

    @Override
    public void process(ResultSet resultSet, RowCallbackHandler rch) throws DataAccessException {
        try {
            for (Row row : resultSet.all()) {
                rch.processRow(row);
            }
        }
        catch (DriverException dx) {
            this.translateExceptionIfPossible((RuntimeException)((Object)dx));
        }
    }

    @Override
    public <T> List<T> process(ResultSet resultSet, RowMapper<T> rowMapper) throws DataAccessException {
        ArrayList<T> mappedRows = new ArrayList<T>();
        try {
            int i = 0;
            for (Row row : resultSet.all()) {
                mappedRows.add(rowMapper.mapRow(row, i++));
            }
        }
        catch (DriverException dx) {
            this.translateExceptionIfPossible((RuntimeException)((Object)dx));
        }
        return mappedRows;
    }

    @Override
    public <T> T processOne(ResultSet resultSet, RowMapper<T> rowMapper) throws DataAccessException {
        T row = null;
        Assert.notNull((Object)resultSet, (String)"ResultSet cannot be null");
        try {
            List rows = resultSet.all();
            Assert.notNull((Object)rows, (String)"null row list returned from query");
            Assert.isTrue((rows.size() == 1 ? 1 : 0) != 0, (String)("row list has " + rows.size() + " rows instead of one"));
            row = rowMapper.mapRow((Row)rows.get(0), 0);
        }
        catch (DriverException dx) {
            this.translateExceptionIfPossible((RuntimeException)((Object)dx));
        }
        return row;
    }

    @Override
    public <T> T processOne(ResultSet resultSet, Class<T> requiredType) throws DataAccessException {
        if (resultSet == null) {
            return null;
        }
        Row row = resultSet.one();
        if (row == null) {
            return null;
        }
        return (T)this.firstColumnToObject(row);
    }

    @Override
    public Map<String, Object> processMap(ResultSet resultSet) throws DataAccessException {
        if (resultSet == null) {
            return null;
        }
        return this.toMap(resultSet.one());
    }

    @Override
    public <T> List<T> processList(ResultSet resultSet, Class<T> elementType) throws DataAccessException {
        List rows = resultSet.all();
        ArrayList<Object> list = new ArrayList<Object>(rows.size());
        for (Row row : rows) {
            list.add(this.firstColumnToObject(row));
        }
        return list;
    }

    @Override
    public List<Map<String, Object>> processListOfMap(ResultSet resultSet) throws DataAccessException {
        List rows = resultSet.all();
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(rows.size());
        for (Row row : rows) {
            list.add(this.toMap(row));
        }
        return list;
    }

    protected RuntimeException translateExceptionIfPossible(RuntimeException ex) {
        DataAccessException resolved = this.getExceptionTranslator().translateExceptionIfPossible(ex);
        return resolved == null ? ex : resolved;
    }

    protected RuntimeException translateExceptionIfPossible(Exception ex) {
        if (ex instanceof RuntimeException) {
            return this.translateExceptionIfPossible((RuntimeException)ex);
        }
        return new CassandraUncategorizedDataAccessException("Caught Uncategorized Exception", ex);
    }

    @Override
    public <T> T execute(PreparedStatementCreator psc, PreparedStatementCallback<T> action) {
        try {
            PreparedStatement ps = psc.createPreparedStatement(this.getSession());
            return action.doInPreparedStatement(ps);
        }
        catch (DriverException dx) {
            throw this.translateExceptionIfPossible((RuntimeException)((Object)dx));
        }
    }

    @Override
    public <T> T execute(String cql, PreparedStatementCallback<T> action) {
        return this.execute(new CachedPreparedStatementCreator(cql), action);
    }

    @Override
    public <T> T query(PreparedStatementCreator psc, ResultSetExtractor<T> rse, QueryOptions options) throws DataAccessException {
        return this.query(psc, null, rse, options);
    }

    @Override
    public <T> T query(PreparedStatementCreator psc, ResultSetExtractor<T> rse) throws DataAccessException {
        return this.query(psc, rse, null);
    }

    @Override
    public void query(PreparedStatementCreator psc, RowCallbackHandler rch, QueryOptions options) throws DataAccessException {
        this.query(psc, null, rch, options);
    }

    @Override
    public void query(PreparedStatementCreator psc, RowCallbackHandler rch) throws DataAccessException {
        this.query(psc, rch, null);
    }

    @Override
    public <T> List<T> query(PreparedStatementCreator psc, RowMapper<T> rowMapper, QueryOptions options) throws DataAccessException {
        return this.query(psc, null, rowMapper, options);
    }

    @Override
    public <T> List<T> query(PreparedStatementCreator psc, RowMapper<T> rowMapper) throws DataAccessException {
        return this.query(psc, rowMapper, null);
    }

    @Override
    public <T> T query(String cql, PreparedStatementBinder psb, ResultSetExtractor<T> rse, QueryOptions options) throws DataAccessException {
        return this.query((PreparedStatementCreator)new CachedPreparedStatementCreator(cql), psb, rse, options);
    }

    @Override
    public <T> T query(String cql, PreparedStatementBinder psb, ResultSetExtractor<T> rse) throws DataAccessException {
        return this.query(cql, psb, rse, null);
    }

    @Override
    public void query(String cql, PreparedStatementBinder psb, RowCallbackHandler rch, QueryOptions options) throws DataAccessException {
        this.query((PreparedStatementCreator)new CachedPreparedStatementCreator(cql), psb, rch, options);
    }

    @Override
    public void query(String cql, PreparedStatementBinder psb, RowCallbackHandler rch) throws DataAccessException {
        this.query(cql, psb, rch, null);
    }

    @Override
    public <T> List<T> query(String cql, PreparedStatementBinder psb, RowMapper<T> rowMapper, QueryOptions options) throws DataAccessException {
        return this.query((PreparedStatementCreator)new CachedPreparedStatementCreator(cql), psb, rowMapper, options);
    }

    @Override
    public <T> List<T> query(String cql, PreparedStatementBinder psb, RowMapper<T> rowMapper) throws DataAccessException {
        return this.query(cql, psb, rowMapper, null);
    }

    @Override
    public void ingest(String cql, RowIterator rowIterator, WriteOptions options) {
        CachedPreparedStatementCreator cpsc = new CachedPreparedStatementCreator(cql);
        PreparedStatement preparedStatement = cpsc.createPreparedStatement(this.getSession());
        CqlTemplate.addPreparedStatementOptions(preparedStatement, options);
        Session s = this.getSession();
        while (rowIterator.hasNext()) {
            s.executeAsync((Statement)preparedStatement.bind(rowIterator.next()));
        }
    }

    @Override
    public void ingest(String cql, RowIterator rowIterator) {
        this.ingest(cql, rowIterator, null);
    }

    @Override
    public void ingest(String cql, final List<List<?>> rows, WriteOptions options) {
        Assert.notNull(rows);
        Assert.notEmpty(rows);
        this.ingest(cql, new RowIterator(){
            Iterator<List<?>> i;
            {
                this.i = rows.iterator();
            }

            @Override
            public Object[] next() {
                return this.i.next().toArray();
            }

            @Override
            public boolean hasNext() {
                return this.i.hasNext();
            }
        }, options);
    }

    @Override
    public void ingest(String cql, List<List<?>> rows) {
        this.ingest(cql, rows, null);
    }

    @Override
    public void ingest(String cql, final Object[][] rows, WriteOptions options) {
        this.ingest(cql, new RowIterator(){
            int index = 0;

            @Override
            public Object[] next() {
                return rows[this.index++];
            }

            @Override
            public boolean hasNext() {
                return this.index < rows.length;
            }
        }, options);
    }

    @Override
    public void ingest(String cql, Object[][] rows) {
        this.ingest(cql, rows, null);
    }

    @Override
    public void truncate(String tableName) throws DataAccessException {
        this.truncate(CqlIdentifier.cqlId(tableName));
    }

    @Override
    public void truncate(CqlIdentifier tableName) throws DataAccessException {
        Truncate truncate = QueryBuilder.truncate((String)tableName.toCql());
        this.doExecute((Statement)truncate);
    }

    @Override
    public <T> T query(PreparedStatementCreator psc, final PreparedStatementBinder psb, final ResultSetExtractor<T> rse, final QueryOptions options) throws DataAccessException {
        Assert.notNull(rse, (String)"ResultSetExtractor must not be null");
        this.logger.debug("Executing prepared CQL query");
        return this.execute(psc, new PreparedStatementCallback<T>(){

            @Override
            public T doInPreparedStatement(PreparedStatement ps) throws DriverException {
                ResultSet rs = null;
                BoundStatement bs = null;
                bs = psb != null ? psb.bindValues(ps) : ps.bind();
                rs = CqlTemplate.this.doExecute(CqlTemplate.addQueryOptions((Statement)bs, options));
                return rse.extractData(rs);
            }
        });
    }

    @Override
    public <T> T query(PreparedStatementCreator psc, PreparedStatementBinder psb, ResultSetExtractor<T> rse) throws DataAccessException {
        return this.query(psc, psb, rse, null);
    }

    @Override
    public void query(PreparedStatementCreator psc, final PreparedStatementBinder psb, final RowCallbackHandler rch, final QueryOptions options) throws DataAccessException {
        Assert.notNull((Object)rch, (String)"RowCallbackHandler must not be null");
        this.logger.debug("Executing prepared CQL query");
        this.execute(psc, new PreparedStatementCallback<Object>(){

            @Override
            public Object doInPreparedStatement(PreparedStatement ps) throws DriverException {
                ResultSet rs = null;
                BoundStatement bs = null;
                bs = psb != null ? psb.bindValues(ps) : ps.bind();
                rs = CqlTemplate.this.doExecute(CqlTemplate.addQueryOptions((Statement)bs, options));
                CqlTemplate.this.process(rs, rch);
                return null;
            }
        });
    }

    @Override
    public void query(PreparedStatementCreator psc, PreparedStatementBinder psb, RowCallbackHandler rch) throws DataAccessException {
        this.query(psc, psb, rch, null);
    }

    @Override
    public <T> List<T> query(PreparedStatementCreator psc, final PreparedStatementBinder psb, final RowMapper<T> rowMapper, final QueryOptions options) throws DataAccessException {
        Assert.notNull(rowMapper, (String)"RowMapper must not be null");
        this.logger.debug("Executing prepared CQL query");
        return (List)this.execute(psc, new PreparedStatementCallback<List<T>>(){

            @Override
            public List<T> doInPreparedStatement(PreparedStatement ps) throws DriverException {
                ResultSet rs = null;
                BoundStatement bs = null;
                bs = psb != null ? psb.bindValues(ps) : ps.bind();
                rs = CqlTemplate.this.doExecute(CqlTemplate.addQueryOptions((Statement)bs, options));
                return CqlTemplate.this.process(rs, rowMapper);
            }
        });
    }

    @Override
    public <T> List<T> query(PreparedStatementCreator psc, PreparedStatementBinder psb, RowMapper<T> rowMapper) throws DataAccessException {
        return this.query(psc, psb, rowMapper, null);
    }

    @Override
    public ResultSet execute(final DropTableSpecification specification) {
        return this.execute(new SessionCallback<ResultSet>(){

            @Override
            public ResultSet doInSession(Session s) throws DataAccessException {
                return s.execute(DropTableCqlGenerator.toCql(specification));
            }
        });
    }

    @Override
    public ResultSet execute(final CreateTableSpecification specification) {
        return this.execute(new SessionCallback<ResultSet>(){

            @Override
            public ResultSet doInSession(Session s) throws DataAccessException {
                return s.execute(CreateTableCqlGenerator.toCql(specification));
            }
        });
    }

    @Override
    public ResultSet execute(final AlterTableSpecification specification) {
        return this.execute(new SessionCallback<ResultSet>(){

            @Override
            public ResultSet doInSession(Session s) throws DataAccessException {
                return s.execute(AlterTableCqlGenerator.toCql(specification));
            }
        });
    }

    @Override
    public ResultSet execute(final DropKeyspaceSpecification specification) {
        return this.execute(new SessionCallback<ResultSet>(){

            @Override
            public ResultSet doInSession(Session s) throws DataAccessException {
                return s.execute(DropKeyspaceCqlGenerator.toCql(specification));
            }
        });
    }

    @Override
    public ResultSet execute(final CreateKeyspaceSpecification specification) {
        return this.execute(new SessionCallback<ResultSet>(){

            @Override
            public ResultSet doInSession(Session s) throws DataAccessException {
                return s.execute(CreateKeyspaceCqlGenerator.toCql(specification));
            }
        });
    }

    @Override
    public ResultSet execute(final AlterKeyspaceSpecification specification) {
        return this.execute(new SessionCallback<ResultSet>(){

            @Override
            public ResultSet doInSession(Session s) throws DataAccessException {
                return s.execute(AlterKeyspaceCqlGenerator.toCql(specification));
            }
        });
    }

    @Override
    public ResultSet execute(final DropIndexSpecification specification) {
        return this.execute(new SessionCallback<ResultSet>(){

            @Override
            public ResultSet doInSession(Session s) throws DataAccessException {
                return s.execute(DropIndexCqlGenerator.toCql(specification));
            }
        });
    }

    @Override
    public ResultSet execute(final CreateIndexSpecification specification) {
        return this.execute(new SessionCallback<ResultSet>(){

            @Override
            public ResultSet doInSession(Session s) throws DataAccessException {
                return s.execute(CreateIndexCqlGenerator.toCql(specification));
            }
        });
    }

    @Override
    public void execute(Delete delete) throws DataAccessException {
        this.doExecute((Statement)delete);
    }

    @Override
    public void execute(Insert insert) throws DataAccessException {
        this.doExecute((Statement)insert);
    }

    @Override
    public void execute(Update update) throws DataAccessException {
        this.doExecute((Statement)update);
    }

    @Override
    public void execute(Batch batch) throws DataAccessException {
        this.doExecute((Statement)batch);
    }

    @Override
    public void execute(Truncate truncate) throws DataAccessException {
        this.doExecute((Statement)truncate);
    }

    @Override
    public long count(CqlIdentifier tableName) {
        return this.selectCount(QueryBuilder.select().countAll().from(tableName.toCql()));
    }

    @Override
    public long count(String tableName) {
        return this.count(CqlIdentifier.cqlId(tableName));
    }

    protected long selectCount(Select select) {
        return this.query(select, new ResultSetExtractor<Long>(){

            @Override
            public Long extractData(ResultSet rs) throws DriverException, DataAccessException {
                Row row = rs.one();
                if (row == null) {
                    throw new InvalidDataAccessApiUsageException(String.format("count query did not return any results", new Object[0]));
                }
                return row.getLong(0);
            }
        });
    }

    @Override
    public ResultSetFuture executeAsynchronously(Truncate truncate) throws DataAccessException {
        return this.doExecuteAsync((Statement)truncate);
    }

    @Override
    public ResultSetFuture executeAsynchronously(Delete delete) throws DataAccessException {
        return this.doExecuteAsync((Statement)delete);
    }

    @Override
    public ResultSetFuture executeAsynchronously(Insert insert) throws DataAccessException {
        return this.doExecuteAsync((Statement)insert);
    }

    @Override
    public ResultSetFuture executeAsynchronously(Update update) throws DataAccessException {
        return this.doExecuteAsync((Statement)update);
    }

    @Override
    public ResultSetFuture executeAsynchronously(Batch batch) throws DataAccessException {
        return this.doExecuteAsync((Statement)batch);
    }

    @Override
    public Cancellable executeAsynchronously(Truncate truncate, AsynchronousQueryListener listener) throws DataAccessException {
        return this.doExecuteAsync((Statement)truncate, listener);
    }

    @Override
    public Cancellable executeAsynchronously(Delete delete, AsynchronousQueryListener listener) throws DataAccessException {
        return this.doExecuteAsync((Statement)delete, listener);
    }

    @Override
    public Cancellable executeAsynchronously(Insert insert, AsynchronousQueryListener listener) throws DataAccessException {
        return this.doExecuteAsync((Statement)insert, listener);
    }

    @Override
    public Cancellable executeAsynchronously(Update update, AsynchronousQueryListener listener) throws DataAccessException {
        return this.doExecuteAsync((Statement)update, listener);
    }

    @Override
    public Cancellable executeAsynchronously(Batch batch, AsynchronousQueryListener listener) throws DataAccessException {
        return this.doExecuteAsync((Statement)batch, listener);
    }

    @Override
    public ResultSetFuture queryAsynchronously(final Select select) {
        return this.execute(new SessionCallback<ResultSetFuture>(){

            @Override
            public ResultSetFuture doInSession(Session s) throws DataAccessException {
                return s.executeAsync((Statement)select);
            }
        });
    }

    @Override
    public Cancellable queryAsynchronously(Select select, Runnable listener) {
        return this.queryAsynchronously(select, listener, new Executor(){

            @Override
            public void execute(Runnable command) {
                command.run();
            }
        });
    }

    @Override
    public Cancellable queryAsynchronously(Select select, AsynchronousQueryListener listener) {
        return this.queryAsynchronously(select, listener, new Executor(){

            @Override
            public void execute(Runnable command) {
                command.run();
            }
        });
    }

    @Override
    public Cancellable queryAsynchronously(final Select select, final AsynchronousQueryListener listener, final Executor executor) {
        return this.execute(new SessionCallback<Cancellable>(){

            @Override
            public Cancellable doInSession(Session s) throws DataAccessException {
                final ResultSetFuture rsf = s.executeAsync((Statement)select);
                Runnable wrapper = new Runnable(){

                    @Override
                    public void run() {
                        listener.onQueryComplete(rsf);
                    }
                };
                rsf.addListener(wrapper, executor);
                return new ResultSetFutureCancellable(rsf);
            }
        });
    }

    @Override
    public Cancellable queryAsynchronously(final Select select, final Runnable listener, final Executor executor) {
        return this.execute(new SessionCallback<Cancellable>(){

            @Override
            public Cancellable doInSession(Session s) throws DataAccessException {
                ResultSetFuture rsf = s.executeAsync((Statement)select);
                rsf.addListener(listener, executor);
                return new ResultSetFutureCancellable(rsf);
            }
        });
    }

    @Override
    public ResultSet query(Select select) {
        return this.query(select, new ResultSetExtractor<ResultSet>(){

            @Override
            public ResultSet extractData(ResultSet rs) throws DriverException, DataAccessException {
                return rs;
            }
        });
    }

    @Override
    public <T> T query(Select select, ResultSetExtractor<T> rse) throws DataAccessException {
        Assert.notNull((Object)select);
        ResultSet rs = this.doExecute((Statement)select);
        return rse.extractData(rs);
    }

    @Override
    public void query(Select select, RowCallbackHandler rch) throws DataAccessException {
        this.process(this.doExecute((Statement)select), rch);
    }

    @Override
    public <T> List<T> query(Select select, RowMapper<T> rowMapper) throws DataAccessException {
        return this.process(this.doExecute((Statement)select), rowMapper);
    }

    @Override
    public <T> T queryForObject(Select select, RowMapper<T> rowMapper) throws DataAccessException {
        return this.processOne(this.doExecute((Statement)select), rowMapper);
    }

    @Override
    public <T> T queryForObject(Select select, Class<T> requiredType) throws DataAccessException {
        return this.processOne(this.doExecute((Statement)select), requiredType);
    }

    @Override
    public Map<String, Object> queryForMap(Select select) throws DataAccessException {
        return this.processMap(this.doExecute((Statement)select));
    }

    @Override
    public <T> List<T> queryForList(Select select, Class<T> elementType) throws DataAccessException {
        return this.processList(this.doExecute((Statement)select), elementType);
    }

    @Override
    public List<Map<String, Object>> queryForListOfMap(Select select) throws DataAccessException {
        return this.processListOfMap(this.doExecute((Statement)select));
    }

    @Override
    public <T> Cancellable queryForListAsynchronously(Select select, final Class<T> elementType, final QueryForListListener<T> listener) throws DataAccessException {
        Assert.notNull((Object)select);
        Assert.notNull(elementType);
        Assert.notNull(listener);
        return this.doExecuteAsync((Statement)select, new AsynchronousQueryListener(){

            @Override
            public void onQueryComplete(ResultSetFuture rsf) {
                try {
                    listener.onQueryComplete(CqlTemplate.this.processList(rsf.getUninterruptibly(), elementType));
                }
                catch (Exception e) {
                    listener.onException(CqlTemplate.this.translateExceptionIfPossible(e));
                }
            }
        });
    }

    @Override
    public <T> Cancellable queryForListAsynchronously(String select, final Class<T> elementType, final QueryForListListener<T> listener) throws DataAccessException {
        Assert.hasText((String)select);
        Assert.notNull(elementType);
        Assert.notNull(listener);
        return this.doExecuteAsync((Statement)new SimpleStatement(select), new AsynchronousQueryListener(){

            @Override
            public void onQueryComplete(ResultSetFuture rsf) {
                try {
                    listener.onQueryComplete(CqlTemplate.this.processList(rsf.getUninterruptibly(), elementType));
                }
                catch (Exception e) {
                    listener.onException(CqlTemplate.this.translateExceptionIfPossible(e));
                }
            }
        });
    }

    @Override
    public Cancellable queryForListOfMapAsynchronously(Select select, final QueryForListListener<Map<String, Object>> listener) throws DataAccessException {
        return this.doExecuteAsync((Statement)select, new AsynchronousQueryListener(){

            @Override
            public void onQueryComplete(ResultSetFuture rsf) {
                try {
                    listener.onQueryComplete(CqlTemplate.this.processListOfMap(rsf.getUninterruptibly()));
                }
                catch (Exception e) {
                    listener.onException(CqlTemplate.this.translateExceptionIfPossible(e));
                }
            }
        });
    }

    @Override
    public Cancellable queryForListOfMapAsynchronously(String cql, QueryForListListener<Map<String, Object>> listener) throws DataAccessException {
        return this.queryForListOfMapAsynchronously(cql, listener, null);
    }

    @Override
    public Cancellable queryForListOfMapAsynchronously(String cql, final QueryForListListener<Map<String, Object>> listener, QueryOptions options) throws DataAccessException {
        return this.doExecuteAsync((Statement)new SimpleStatement(cql), new AsynchronousQueryListener(){

            @Override
            public void onQueryComplete(ResultSetFuture rsf) {
                try {
                    listener.onQueryComplete(CqlTemplate.this.processListOfMap(rsf.getUninterruptibly()));
                }
                catch (Exception e) {
                    listener.onException(CqlTemplate.this.translateExceptionIfPossible(e));
                }
            }
        }, options);
    }

    @Override
    public Cancellable queryForMapAsynchronously(String cql, QueryForMapListener listener) throws DataAccessException {
        return this.queryForMapAsynchronously(cql, listener, null);
    }

    @Override
    public Cancellable queryForMapAsynchronously(String cql, final QueryForMapListener listener, QueryOptions options) throws DataAccessException {
        return this.doExecuteAsync((Statement)new SimpleStatement(cql), new AsynchronousQueryListener(){

            @Override
            public void onQueryComplete(ResultSetFuture rsf) {
                try {
                    listener.onQueryComplete(CqlTemplate.this.processMap(rsf.getUninterruptibly()));
                }
                catch (Exception e) {
                    listener.onException(CqlTemplate.this.translateExceptionIfPossible(e));
                }
            }
        }, options);
    }

    @Override
    public Cancellable queryForMapAsynchronously(Select select, final QueryForMapListener listener) throws DataAccessException {
        return this.doExecuteAsync((Statement)select, new AsynchronousQueryListener(){

            @Override
            public void onQueryComplete(ResultSetFuture rsf) {
                try {
                    listener.onQueryComplete(CqlTemplate.this.processMap(rsf.getUninterruptibly()));
                }
                catch (Exception e) {
                    listener.onException(CqlTemplate.this.translateExceptionIfPossible(e));
                }
            }
        });
    }

    @Override
    public <T> Cancellable queryForObjectAsynchronously(Select select, final Class<T> requiredType, final QueryForObjectListener<T> listener) throws DataAccessException {
        return this.doExecuteAsync((Statement)select, new AsynchronousQueryListener(){

            @Override
            public void onQueryComplete(ResultSetFuture rsf) {
                try {
                    listener.onQueryComplete(CqlTemplate.this.processOne(rsf.getUninterruptibly(), requiredType));
                }
                catch (Exception e) {
                    listener.onException(CqlTemplate.this.translateExceptionIfPossible(e));
                }
            }
        });
    }

    @Override
    public <T> Cancellable queryForObjectAsynchronously(String cql, Class<T> requiredType, QueryForObjectListener<T> listener) throws DataAccessException {
        return this.queryForObjectAsynchronously(cql, requiredType, listener, null);
    }

    @Override
    public <T> Cancellable queryForObjectAsynchronously(String cql, final Class<T> requiredType, final QueryForObjectListener<T> listener, QueryOptions options) throws DataAccessException {
        return this.doExecuteAsync((Statement)new SimpleStatement(cql), new AsynchronousQueryListener(){

            @Override
            public void onQueryComplete(ResultSetFuture rsf) {
                try {
                    listener.onQueryComplete(CqlTemplate.this.processOne(rsf.getUninterruptibly(), requiredType));
                }
                catch (Exception e) {
                    listener.onException(CqlTemplate.this.translateExceptionIfPossible(e));
                }
            }
        }, options);
    }

    @Override
    public <T> Cancellable queryForObjectAsynchronously(String cql, RowMapper<T> rowMapper, QueryForObjectListener<T> listener) throws DataAccessException {
        return this.queryForObjectAsynchronously(cql, rowMapper, listener, null);
    }

    @Override
    public <T> Cancellable queryForObjectAsynchronously(String cql, final RowMapper<T> rowMapper, final QueryForObjectListener<T> listener, QueryOptions options) throws DataAccessException {
        return this.doExecuteAsync((Statement)new SimpleStatement(cql), new AsynchronousQueryListener(){

            @Override
            public void onQueryComplete(ResultSetFuture rsf) {
                try {
                    listener.onQueryComplete(CqlTemplate.this.processOne(rsf.getUninterruptibly(), rowMapper));
                }
                catch (Exception e) {
                    listener.onException(CqlTemplate.this.translateExceptionIfPossible(e));
                }
            }
        }, options);
    }

    @Override
    public <T> Cancellable queryForObjectAsynchronously(Select select, final RowMapper<T> rowMapper, final QueryForObjectListener<T> listener) throws DataAccessException {
        return this.doExecuteAsync((Statement)select, new AsynchronousQueryListener(){

            @Override
            public void onQueryComplete(ResultSetFuture rsf) {
                try {
                    listener.onQueryComplete(CqlTemplate.this.processOne(rsf.getUninterruptibly(), rowMapper));
                }
                catch (Exception e) {
                    listener.onException(CqlTemplate.this.translateExceptionIfPossible(e));
                }
            }
        });
    }

    @Override
    public ResultSet getResultSetUninterruptibly(ResultSetFuture rsf) {
        return this.getResultSetUninterruptibly(rsf, 0L, null);
    }

    @Override
    public ResultSet getResultSetUninterruptibly(ResultSetFuture rsf, long millis) {
        return this.getResultSetUninterruptibly(rsf, millis, TimeUnit.MILLISECONDS);
    }

    @Override
    public ResultSet getResultSetUninterruptibly(ResultSetFuture rsf, long timeout, TimeUnit unit) {
        try {
            return timeout <= 0L ? rsf.getUninterruptibly() : rsf.getUninterruptibly(timeout, unit == null ? TimeUnit.MILLISECONDS : unit);
        }
        catch (Exception x) {
            throw this.translateExceptionIfPossible(x);
        }
    }
}

