/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cassandra.core.keyspace;

import org.springframework.cassandra.config.DataCenterReplication;
import org.springframework.cassandra.core.cql.KeyspaceIdentifier;
import org.springframework.cassandra.core.keyspace.DefaultOption;
import org.springframework.cassandra.core.keyspace.KeyspaceOption;
import org.springframework.cassandra.core.keyspace.KeyspaceSpecification;
import org.springframework.cassandra.core.keyspace.Option;
import org.springframework.cassandra.core.util.MapBuilder;

public class CreateKeyspaceSpecification
extends KeyspaceSpecification<CreateKeyspaceSpecification> {
    private boolean ifNotExists = false;

    public static CreateKeyspaceSpecification createKeyspace() {
        return new CreateKeyspaceSpecification();
    }

    public static CreateKeyspaceSpecification createKeyspace(String name) {
        return new CreateKeyspaceSpecification(name);
    }

    public static CreateKeyspaceSpecification createKeyspace(KeyspaceIdentifier name) {
        return new CreateKeyspaceSpecification(name);
    }

    public CreateKeyspaceSpecification() {
    }

    public CreateKeyspaceSpecification(String name) {
        this.name(name);
    }

    public CreateKeyspaceSpecification(KeyspaceIdentifier name) {
        this.name(name);
    }

    public CreateKeyspaceSpecification ifNotExists() {
        return this.ifNotExists(true);
    }

    public CreateKeyspaceSpecification ifNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
        return this;
    }

    public boolean getIfNotExists() {
        return this.ifNotExists;
    }

    public CreateKeyspaceSpecification withSimpleReplication() {
        return this.withSimpleReplication(1L);
    }

    public CreateKeyspaceSpecification withSimpleReplication(long replicationFactor) {
        return this.with(KeyspaceOption.REPLICATION, MapBuilder.map(Option.class, Object.class).entry(new DefaultOption("class", String.class, true, false, true), KeyspaceOption.ReplicationStrategy.SIMPLE_STRATEGY.getValue()).entry(new DefaultOption("replication_factor", Long.class, true, false, false), replicationFactor).build());
    }

    public CreateKeyspaceSpecification withNetworkReplication(DataCenterReplication ... dcrs) {
        MapBuilder<Option, Object> builder = MapBuilder.map(Option.class, Object.class).entry(new DefaultOption("class", String.class, true, false, true), KeyspaceOption.ReplicationStrategy.NETWORK_TOPOLOGY_STRATEGY.getValue());
        for (DataCenterReplication dcr : dcrs) {
            builder.entry(new DefaultOption(dcr.dataCenter, Long.class, true, false, false), dcr.replicationFactor);
        }
        return this.with(KeyspaceOption.REPLICATION, builder.build());
    }

    @Override
    public CreateKeyspaceSpecification name(String name) {
        return (CreateKeyspaceSpecification)super.name(name);
    }

    @Override
    public CreateKeyspaceSpecification name(KeyspaceIdentifier name) {
        return (CreateKeyspaceSpecification)super.name(name);
    }

    @Override
    public CreateKeyspaceSpecification with(KeyspaceOption option) {
        return (CreateKeyspaceSpecification)super.with(option);
    }

    @Override
    public CreateKeyspaceSpecification with(KeyspaceOption option, Object value) {
        return (CreateKeyspaceSpecification)super.with(option, value);
    }

    @Override
    public CreateKeyspaceSpecification with(String name, Object value, boolean escape, boolean quote) {
        return (CreateKeyspaceSpecification)super.with(name, value, escape, quote);
    }
}

