/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cassandra.core.cql.generator;

import java.util.Map;
import org.springframework.cassandra.core.cql.CqlStringUtils;
import org.springframework.cassandra.core.cql.generator.KeyspaceOptionsCqlGenerator;
import org.springframework.cassandra.core.keyspace.AlterKeyspaceSpecification;

public class AlterKeyspaceCqlGenerator
extends KeyspaceOptionsCqlGenerator<AlterKeyspaceSpecification> {
    public static String toCql(AlterKeyspaceSpecification specification) {
        return new AlterKeyspaceCqlGenerator(specification).toCql();
    }

    public AlterKeyspaceCqlGenerator(AlterKeyspaceSpecification specification) {
        super(specification);
    }

    @Override
    public StringBuilder toCql(StringBuilder cql) {
        cql = CqlStringUtils.noNull(cql);
        this.preambleCql(cql);
        this.optionsCql(cql);
        cql.append(";");
        return cql;
    }

    protected StringBuilder preambleCql(StringBuilder cql) {
        return CqlStringUtils.noNull(cql).append("ALTER KEYSPACE ").append(((AlterKeyspaceSpecification)this.spec()).getName()).append(" ");
    }

    protected StringBuilder optionsCql(StringBuilder cql) {
        cql = CqlStringUtils.noNull(cql);
        Map<String, Object> options = ((AlterKeyspaceSpecification)this.spec()).getOptions();
        if (!options.isEmpty()) {
            boolean first = true;
            cql.append(" WITH ");
            if (!options.isEmpty()) {
                for (String name : options.keySet()) {
                    if (first) {
                        first = false;
                    } else {
                        cql.append(" AND ");
                    }
                    cql.append(name);
                    Object value = options.get(name);
                    if (value == null) continue;
                    cql.append(" = ");
                    if (value instanceof Map) {
                        this.optionValueMap((Map)value, cql);
                        continue;
                    }
                    cql.append(value.toString());
                }
            }
        }
        return cql;
    }
}

