/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cassandra.core;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.exceptions.DriverException;
import org.springframework.cassandra.core.PreparedStatementCreator;
import org.springframework.util.Assert;

public class SimplePreparedStatementCreator
implements PreparedStatementCreator {
    private final String cql;

    public SimplePreparedStatementCreator(String cql) {
        Assert.notNull((Object)cql, (String)"CQL is required to create a PreparedStatement");
        this.cql = cql;
    }

    public String getCql() {
        return this.cql;
    }

    @Override
    public PreparedStatement createPreparedStatement(Session session) throws DriverException {
        return session.prepare(this.cql);
    }
}

