/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cassandra.config;

import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;

public class MultiLevelSetFlattenerFactoryBean<T>
implements FactoryBean<Set<T>> {
    private static final Logger log = LoggerFactory.getLogger(MultiLevelSetFlattenerFactoryBean.class);
    private Set<Set<T>> multiLevelSet;

    public Set<T> getObject() throws Exception {
        HashSet<T> set = new HashSet<T>();
        for (Set<T> topSet : this.multiLevelSet) {
            for (T t : topSet) {
                log.debug(t.toString());
                log.debug("Set contains -> " + set.contains(t));
                set.add(t);
            }
        }
        return set;
    }

    public Class<?> getObjectType() {
        return Set.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public Set<Set<T>> getMultiLevelSet() {
        return this.multiLevelSet;
    }

    public void setMultiLevelSet(Set<Set<T>> multiLevelSet) {
        this.multiLevelSet = multiLevelSet;
    }
}

