/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.zookeeper.serviceregistry;

import java.io.Closeable;
import java.io.IOException;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.x.discovery.ServiceDiscovery;
import org.apache.curator.x.discovery.ServiceInstance;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.cloud.client.serviceregistry.ServiceRegistry;
import org.springframework.cloud.zookeeper.discovery.ZookeeperDiscoveryProperties;
import org.springframework.cloud.zookeeper.discovery.ZookeeperInstance;
import org.springframework.cloud.zookeeper.serviceregistry.ZookeeperRegistration;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class ZookeeperServiceRegistry
implements ServiceRegistry<ZookeeperRegistration>,
SmartInitializingSingleton,
Closeable {
    protected CuratorFramework curator;
    protected ZookeeperDiscoveryProperties properties;
    private ServiceDiscovery<ZookeeperInstance> serviceDiscovery;

    public ZookeeperServiceRegistry(ServiceDiscovery<ZookeeperInstance> serviceDiscovery) {
        this.serviceDiscovery = serviceDiscovery;
    }

    public void register(ZookeeperRegistration registration) {
        try {
            this.getServiceDiscovery().registerService(registration.getServiceInstance());
        }
        catch (Exception e) {
            ReflectionUtils.rethrowRuntimeException((Throwable)e);
        }
    }

    private ServiceDiscovery<ZookeeperInstance> getServiceDiscovery() {
        return this.serviceDiscovery;
    }

    public void deregister(ZookeeperRegistration registration) {
        try {
            this.getServiceDiscovery().unregisterService(registration.getServiceInstance());
        }
        catch (Exception e) {
            ReflectionUtils.rethrowRuntimeException((Throwable)e);
        }
    }

    public void afterSingletonsInstantiated() {
        try {
            this.getServiceDiscovery().start();
        }
        catch (Exception e) {
            ReflectionUtils.rethrowRuntimeException((Throwable)e);
        }
    }

    @Override
    public void close() {
        try {
            this.getServiceDiscovery().close();
        }
        catch (IOException e) {
            ReflectionUtils.rethrowRuntimeException((Throwable)e);
        }
    }

    public void setStatus(ZookeeperRegistration registration, String status) {
        ServiceInstance<ZookeeperInstance> serviceInstance = registration.getServiceInstance();
        ZookeeperInstance instance = (ZookeeperInstance)serviceInstance.getPayload();
        instance.getMetadata().put("instance_status", status);
        try {
            this.getServiceDiscovery().updateService(serviceInstance);
        }
        catch (Exception e) {
            ReflectionUtils.rethrowRuntimeException((Throwable)e);
        }
    }

    public Object getStatus(ZookeeperRegistration registration) {
        ZookeeperInstance instance = (ZookeeperInstance)registration.getServiceInstance().getPayload();
        String instanceStatus = instance.getMetadata().get("instance_status");
        if (!StringUtils.hasText((String)instanceStatus)) {
            instanceStatus = "UP";
        }
        return instanceStatus;
    }

    @Deprecated
    protected CuratorFramework getCurator() {
        return this.curator;
    }
}

