/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.zookeeper.discovery.watcher;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.curator.x.discovery.ServiceCache;
import org.apache.curator.x.discovery.ServiceDiscovery;
import org.springframework.cloud.client.discovery.event.InstanceRegisteredEvent;
import org.springframework.cloud.zookeeper.discovery.ZookeeperInstance;
import org.springframework.cloud.zookeeper.discovery.dependency.ZookeeperDependencies;
import org.springframework.cloud.zookeeper.discovery.dependency.ZookeeperDependency;
import org.springframework.cloud.zookeeper.discovery.watcher.DependencyRegistrationHookProvider;
import org.springframework.cloud.zookeeper.discovery.watcher.DependencyStateChangeListenerRegistry;
import org.springframework.cloud.zookeeper.discovery.watcher.DependencyWatcherListener;
import org.springframework.cloud.zookeeper.discovery.watcher.presence.DependencyPresenceOnStartupVerifier;
import org.springframework.context.ApplicationListener;
import org.springframework.util.ReflectionUtils;

public class DefaultDependencyWatcher
implements DependencyRegistrationHookProvider,
ApplicationListener<InstanceRegisteredEvent<?>> {
    private final Map<String, ServiceCache<?>> dependencyRegistry = new ConcurrentHashMap();
    private final List<DependencyWatcherListener> listeners;
    private ServiceDiscovery<ZookeeperInstance> serviceDiscovery;
    private final DependencyPresenceOnStartupVerifier dependencyPresenceOnStartupVerifier;
    private final ZookeeperDependencies zookeeperDependencies;

    public DefaultDependencyWatcher(ServiceDiscovery<ZookeeperInstance> serviceDiscovery, DependencyPresenceOnStartupVerifier dependencyPresenceOnStartupVerifier, List<DependencyWatcherListener> dependencyWatcherListeners, ZookeeperDependencies zookeeperDependencies) {
        this.serviceDiscovery = serviceDiscovery;
        this.dependencyPresenceOnStartupVerifier = dependencyPresenceOnStartupVerifier;
        this.listeners = dependencyWatcherListeners;
        this.zookeeperDependencies = zookeeperDependencies;
    }

    public void onApplicationEvent(InstanceRegisteredEvent<?> event) {
        this.registerDependencyRegistrationHooks();
    }

    @Override
    public void registerDependencyRegistrationHooks() {
        for (ZookeeperDependency zookeeperDependency : this.zookeeperDependencies.getDependencyConfigurations()) {
            String dependencyPath = zookeeperDependency.getPath();
            ServiceCache serviceCache = this.getServiceDiscovery().serviceCacheBuilder().name(dependencyPath).build();
            try {
                serviceCache.start();
            }
            catch (Exception e) {
                ReflectionUtils.rethrowRuntimeException((Throwable)e);
            }
            this.dependencyPresenceOnStartupVerifier.verifyDependencyPresence(dependencyPath, serviceCache, zookeeperDependency.isRequired());
            this.dependencyRegistry.put(dependencyPath, serviceCache);
            serviceCache.addListener((Object)new DependencyStateChangeListenerRegistry(this.listeners, dependencyPath, serviceCache));
        }
    }

    private ServiceDiscovery<ZookeeperInstance> getServiceDiscovery() {
        return this.serviceDiscovery;
    }

    @Override
    public void clearDependencyRegistrationHooks() throws IOException {
        for (ServiceCache<?> cache : this.dependencyRegistry.values()) {
            cache.close();
        }
    }
}

