/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.zookeeper.discovery.watcher;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.x.discovery.ServiceCache;
import org.apache.curator.x.discovery.details.ServiceCacheListener;
import org.springframework.cloud.zookeeper.discovery.watcher.DependencyState;
import org.springframework.cloud.zookeeper.discovery.watcher.DependencyWatcherListener;

public class DependencyStateChangeListenerRegistry
implements ServiceCacheListener {
    private static final Log log = LogFactory.getLog(DependencyStateChangeListenerRegistry.class);
    private final List<DependencyWatcherListener> listeners;
    private final String dependencyName;
    private final ServiceCache<?> serviceCache;

    public DependencyStateChangeListenerRegistry(List<DependencyWatcherListener> listeners, String dependencyName, ServiceCache<?> serviceCache) {
        this.listeners = listeners;
        this.dependencyName = dependencyName;
        this.serviceCache = serviceCache;
    }

    public void cacheChanged() {
        DependencyState state = this.serviceCache.getInstances().isEmpty() ? DependencyState.DISCONNECTED : DependencyState.CONNECTED;
        this.logCurrentState(state);
        this.informListeners(state);
    }

    private void logCurrentState(DependencyState dependencyState) {
        log.info((Object)("Service cache state change for '" + this.dependencyName + "' instances, current service state: " + dependencyState));
    }

    private void informListeners(DependencyState state) {
        for (DependencyWatcherListener listener : this.listeners) {
            listener.stateChanged(this.dependencyName, state);
        }
    }

    public void stateChanged(CuratorFramework client, ConnectionState newState) {
    }
}

