/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.zookeeper.discovery.reactive;

import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.curator.x.discovery.ServiceDiscovery;
import org.apache.curator.x.discovery.ServiceInstance;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.discovery.ReactiveDiscoveryClient;
import org.springframework.cloud.zookeeper.discovery.ZookeeperDiscoveryProperties;
import org.springframework.cloud.zookeeper.discovery.ZookeeperInstance;
import org.springframework.cloud.zookeeper.discovery.ZookeeperServiceInstance;
import org.springframework.cloud.zookeeper.discovery.dependency.ZookeeperDependencies;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class ZookeeperReactiveDiscoveryClient
implements ReactiveDiscoveryClient {
    private static final Logger logger = LoggerFactory.getLogger(ZookeeperReactiveDiscoveryClient.class);
    private final ServiceDiscovery<ZookeeperInstance> serviceDiscovery;
    private final ZookeeperDependencies zookeeperDependencies;
    private final ZookeeperDiscoveryProperties zookeeperDiscoveryProperties;

    public ZookeeperReactiveDiscoveryClient(ServiceDiscovery<ZookeeperInstance> serviceDiscovery, ZookeeperDependencies zookeeperDependencies, ZookeeperDiscoveryProperties zookeeperDiscoveryProperties) {
        this.serviceDiscovery = serviceDiscovery;
        this.zookeeperDependencies = zookeeperDependencies;
        this.zookeeperDiscoveryProperties = zookeeperDiscoveryProperties;
    }

    public String description() {
        return "Spring Cloud Zookeeper Reactive Discovery Client";
    }

    public Flux<org.springframework.cloud.client.ServiceInstance> getInstances(String serviceId) {
        String serviceIdToQuery = this.serviceIdToQuery(serviceId);
        return Mono.justOrEmpty((Object)serviceIdToQuery).flatMapMany(this.getInstancesFromZookeeper()).subscribeOn(Schedulers.boundedElastic()).map(zkInstance -> this.toZookeeperServiceInstance(serviceIdToQuery, (ServiceInstance<ZookeeperInstance>)zkInstance));
    }

    private Function<String, Publisher<ServiceInstance<ZookeeperInstance>>> getInstancesFromZookeeper() {
        return service -> {
            try {
                return Flux.fromIterable((Iterable)this.serviceDiscovery.queryForInstances(service));
            }
            catch (Exception e) {
                logger.error("Error getting instances from zookeeper. Possibly, no service has registered.", (Throwable)e);
                return Flux.empty();
            }
        };
    }

    private ZookeeperServiceInstance toZookeeperServiceInstance(String serviceId, ServiceInstance<ZookeeperInstance> zkInstanceServiceInstance) {
        return new ZookeeperServiceInstance(serviceId, zkInstanceServiceInstance);
    }

    public Flux<String> getServices() {
        return Flux.defer(this.getServicesFromZookeeper()).subscribeOn(Schedulers.boundedElastic());
    }

    private Supplier<Publisher<String>> getServicesFromZookeeper() {
        return () -> {
            try {
                return Flux.fromIterable((Iterable)this.serviceDiscovery.queryForNames());
            }
            catch (Exception e) {
                logger.error("Error getting services from zookeeper. Possibly, no service has registered.", (Throwable)e);
                return Flux.empty();
            }
        };
    }

    private String serviceIdToQuery(String serviceId) {
        if (this.zookeeperDependencies != null && this.zookeeperDependencies.hasDependencies()) {
            String pathForAlias = this.zookeeperDependencies.getPathForAlias(serviceId);
            return pathForAlias.isEmpty() ? serviceId : pathForAlias;
        }
        return serviceId;
    }

    public int getOrder() {
        return this.zookeeperDiscoveryProperties.getOrder();
    }
}

