/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.zookeeper.discovery;

public final class DependencyPathUtils {
    private DependencyPathUtils() {
    }

    public static String sanitize(String path) {
        return DependencyPathUtils.withLeadingSlash(DependencyPathUtils.withoutSlashAtEnd(path));
    }

    private static String withLeadingSlash(String value) {
        return value.startsWith("/") ? value : "/" + value;
    }

    private static String withoutSlashAtEnd(String value) {
        return value.endsWith("/") ? value.substring(0, value.length() - 1) : value;
    }
}

