/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.zookeeper.discovery.configclient;

import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.x.discovery.ServiceDiscovery;
import org.apache.curator.x.discovery.ServiceDiscoveryBuilder;
import org.apache.curator.x.discovery.details.InstanceSerializer;
import org.apache.curator.x.discovery.details.JsonInstanceSerializer;
import org.springframework.boot.BootstrapContext;
import org.springframework.boot.BootstrapRegistry;
import org.springframework.boot.BootstrapRegistryInitializer;
import org.springframework.boot.context.properties.bind.BindHandler;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.commons.util.InetUtils;
import org.springframework.cloud.commons.util.InetUtilsProperties;
import org.springframework.cloud.config.client.ConfigServerInstanceProvider;
import org.springframework.cloud.zookeeper.CuratorFactory;
import org.springframework.cloud.zookeeper.CuratorFrameworkCustomizer;
import org.springframework.cloud.zookeeper.ZookeeperProperties;
import org.springframework.cloud.zookeeper.discovery.ZookeeperDiscoveryClient;
import org.springframework.cloud.zookeeper.discovery.ZookeeperDiscoveryProperties;
import org.springframework.cloud.zookeeper.discovery.ZookeeperInstance;
import org.springframework.cloud.zookeeper.discovery.dependency.ZookeeperDependencies;
import org.springframework.cloud.zookeeper.support.DefaultServiceDiscoveryCustomizer;
import org.springframework.cloud.zookeeper.support.ServiceDiscoveryCustomizer;
import org.springframework.util.ClassUtils;

public class ZookeeperConfigServerBootstrapper
implements BootstrapRegistryInitializer {
    private static boolean isEnabled(Binder binder) {
        return (Boolean)binder.bind("spring.cloud.config.discovery.enabled", Boolean.class).orElse((Object)false) != false && (Boolean)binder.bind("spring.cloud.zookeeper.discovery.enabled", Boolean.class).orElse((Object)true) != false && (Boolean)binder.bind("spring.cloud.discovery.enabled", Boolean.class).orElse((Object)true) != false;
    }

    public void initialize(BootstrapRegistry registry) {
        if (!ClassUtils.isPresent((String)"org.springframework.cloud.config.client.ConfigServerInstanceProvider", null) || ClassUtils.isPresent((String)"org.springframework.cloud.bootstrap.marker.Marker", null)) {
            return;
        }
        CuratorFactory.registerCurator((BootstrapRegistry)registry, null, (boolean)true, bootstrapContext -> ZookeeperConfigServerBootstrapper.isEnabled((Binder)bootstrapContext.get(Binder.class)));
        registry.registerIfAbsent(ZookeeperDiscoveryProperties.class, context -> {
            Binder binder = (Binder)context.get(Binder.class);
            if (!ZookeeperConfigServerBootstrapper.isEnabled(binder)) {
                return null;
            }
            return (ZookeeperDiscoveryProperties)binder.bind("spring.cloud.zookeeper.discovery", Bindable.of(ZookeeperDiscoveryProperties.class), this.getBindHandler(context)).orElseGet(() -> new ZookeeperDiscoveryProperties(new InetUtils(new InetUtilsProperties())));
        });
        registry.registerIfAbsent(InstanceSerializer.class, context -> {
            if (!ZookeeperConfigServerBootstrapper.isEnabled((Binder)context.get(Binder.class))) {
                return null;
            }
            return new JsonInstanceSerializer(ZookeeperInstance.class);
        });
        registry.registerIfAbsent(ServiceDiscoveryCustomizer.class, context -> {
            if (!ZookeeperConfigServerBootstrapper.isEnabled((Binder)context.get(Binder.class))) {
                return null;
            }
            CuratorFramework curator = (CuratorFramework)context.get(CuratorFramework.class);
            ZookeeperDiscoveryProperties properties = (ZookeeperDiscoveryProperties)context.get(ZookeeperDiscoveryProperties.class);
            InstanceSerializer serializer = (InstanceSerializer)context.get(InstanceSerializer.class);
            return new DefaultServiceDiscoveryCustomizer(curator, properties, (InstanceSerializer<ZookeeperInstance>)serializer);
        });
        registry.registerIfAbsent(ServiceDiscovery.class, context -> {
            if (!ZookeeperConfigServerBootstrapper.isEnabled((Binder)context.get(Binder.class))) {
                return null;
            }
            ServiceDiscoveryCustomizer customizer = (ServiceDiscoveryCustomizer)context.get(ServiceDiscoveryCustomizer.class);
            return customizer.customize((ServiceDiscoveryBuilder<ZookeeperInstance>)ServiceDiscoveryBuilder.builder(ZookeeperInstance.class));
        });
        registry.registerIfAbsent(ZookeeperDiscoveryClient.class, context -> {
            Binder binder = (Binder)context.get(Binder.class);
            if (!ZookeeperConfigServerBootstrapper.isEnabled(binder)) {
                return null;
            }
            ServiceDiscovery serviceDiscovery = (ServiceDiscovery)context.get(ServiceDiscovery.class);
            ZookeeperDependencies dependencies = (ZookeeperDependencies)binder.bind("spring.cloud.zookeeper", Bindable.of(ZookeeperDependencies.class), this.getBindHandler(context)).orElseGet(ZookeeperDependencies::new);
            ZookeeperDiscoveryProperties discoveryProperties = (ZookeeperDiscoveryProperties)context.get(ZookeeperDiscoveryProperties.class);
            return new ZookeeperDiscoveryClient((ServiceDiscovery<ZookeeperInstance>)serviceDiscovery, dependencies, discoveryProperties);
        });
        registry.registerIfAbsent(ConfigServerInstanceProvider.Function.class, ZookeeperFunction::create);
        registry.addCloseListener(event -> {
            ZookeeperDiscoveryClient discoveryClient = (ZookeeperDiscoveryClient)event.getBootstrapContext().get(ZookeeperDiscoveryClient.class);
            if (discoveryClient != null) {
                event.getApplicationContext().getBeanFactory().registerSingleton("zookeeperServiceDiscovery", (Object)discoveryClient);
            }
        });
    }

    private BindHandler getBindHandler(BootstrapContext context) {
        return (BindHandler)context.getOrElse(BindHandler.class, null);
    }

    static final class ZookeeperFunction
    implements ConfigServerInstanceProvider.Function {
        private final BootstrapContext context;

        private ZookeeperFunction(BootstrapContext context) {
            this.context = context;
        }

        static ZookeeperFunction create(BootstrapContext context) {
            return new ZookeeperFunction(context);
        }

        public List<ServiceInstance> apply(String serviceId) {
            return this.apply(serviceId, null, null, null);
        }

        public List<ServiceInstance> apply(String serviceId, Binder binder, BindHandler bindHandler, Log log) {
            if (binder == null || !ZookeeperConfigServerBootstrapper.isEnabled(binder)) {
                return Collections.emptyList();
            }
            ZookeeperProperties properties = (ZookeeperProperties)binder.bind("spring.cloud.zookeeper", Bindable.of(ZookeeperProperties.class)).orElse((Object)new ZookeeperProperties());
            ExponentialBackoffRetry retryPolicy = new ExponentialBackoffRetry(properties.getBaseSleepTimeMs().intValue(), properties.getMaxRetries().intValue(), properties.getMaxSleepMs().intValue());
            try {
                CuratorFramework curatorFramework = CuratorFactory.curatorFramework((ZookeeperProperties)properties, (RetryPolicy)retryPolicy, () -> Stream.of(new CuratorFrameworkCustomizer[0]), () -> null, () -> null);
                JsonInstanceSerializer serializer = new JsonInstanceSerializer(ZookeeperInstance.class);
                ZookeeperDiscoveryProperties discoveryProperties = (ZookeeperDiscoveryProperties)binder.bind("spring.cloud.zookeeper.discovery", Bindable.of(ZookeeperDiscoveryProperties.class), bindHandler).orElseGet(() -> new ZookeeperDiscoveryProperties(new InetUtils(new InetUtilsProperties())));
                DefaultServiceDiscoveryCustomizer customizer = new DefaultServiceDiscoveryCustomizer(curatorFramework, discoveryProperties, (InstanceSerializer<ZookeeperInstance>)serializer);
                ServiceDiscovery<ZookeeperInstance> serviceDiscovery = customizer.customize((ServiceDiscoveryBuilder<ZookeeperInstance>)ServiceDiscoveryBuilder.builder(ZookeeperInstance.class));
                ZookeeperDependencies dependencies = (ZookeeperDependencies)binder.bind("spring.cloud.zookeeper", Bindable.of(ZookeeperDependencies.class), bindHandler).orElseGet(ZookeeperDependencies::new);
                return new ZookeeperDiscoveryClient(serviceDiscovery, dependencies, discoveryProperties).getInstances(serviceId);
            }
            catch (Exception e) {
                log.warn((Object)"Error fetching config server instance from Zookeeper", (Throwable)e);
                return Collections.emptyList();
            }
        }
    }
}

