/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.zookeeper.discovery;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.zookeeper.discovery.ZookeeperInstance;

public class ZookeeperServiceInstance
implements ServiceInstance {
    private final String serviceId;
    private final String host;
    private final int port;
    private final boolean secure;
    private final URI uri;
    private final Map<String, String> metadata;
    private final org.apache.curator.x.discovery.ServiceInstance<ZookeeperInstance> serviceInstance;

    public ZookeeperServiceInstance(String serviceId, org.apache.curator.x.discovery.ServiceInstance<ZookeeperInstance> serviceInstance) {
        this.serviceId = serviceId;
        this.serviceInstance = serviceInstance;
        this.host = this.serviceInstance.getAddress();
        this.secure = serviceInstance.getSslPort() != null;
        Integer port = serviceInstance.getPort();
        if (this.secure) {
            port = serviceInstance.getSslPort();
        }
        this.port = port;
        this.uri = URI.create(serviceInstance.buildUriSpec());
        this.metadata = serviceInstance.getPayload() != null ? ((ZookeeperInstance)serviceInstance.getPayload()).getMetadata() : new HashMap<String, String>();
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public URI getUri() {
        return this.uri;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public org.apache.curator.x.discovery.ServiceInstance<ZookeeperInstance> getServiceInstance() {
        return this.serviceInstance;
    }
}

