/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.zookeeper.discovery;

import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.x.discovery.ServiceDiscovery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.Endpoint;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.client.CommonsClientAutoConfiguration;
import org.springframework.cloud.client.discovery.noop.NoopDiscoveryClientAutoConfiguration;
import org.springframework.cloud.commons.util.InetUtils;
import org.springframework.cloud.zookeeper.discovery.ConditionalOnZookeeperDiscoveryEnabled;
import org.springframework.cloud.zookeeper.discovery.ZookeeperDiscoveryClient;
import org.springframework.cloud.zookeeper.discovery.ZookeeperDiscoveryClientConfiguration;
import org.springframework.cloud.zookeeper.discovery.ZookeeperDiscoveryHealthIndicator;
import org.springframework.cloud.zookeeper.discovery.ZookeeperDiscoveryProperties;
import org.springframework.cloud.zookeeper.discovery.ZookeeperInstance;
import org.springframework.cloud.zookeeper.discovery.ZookeeperServiceDiscovery;
import org.springframework.cloud.zookeeper.discovery.ZookeeperServiceWatch;
import org.springframework.cloud.zookeeper.discovery.dependency.ZookeeperDependencies;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnBean(value={ZookeeperDiscoveryClientConfiguration.Marker.class})
@ConditionalOnZookeeperDiscoveryEnabled
@AutoConfigureBefore(value={CommonsClientAutoConfiguration.class, NoopDiscoveryClientAutoConfiguration.class})
public class ZookeeperDiscoveryAutoConfiguration {
    @Autowired(required=false)
    private ZookeeperDependencies zookeeperDependencies;
    @Autowired
    private CuratorFramework curator;

    @Bean
    @ConditionalOnMissingBean
    public ZookeeperDiscoveryProperties zookeeperDiscoveryProperties(InetUtils inetUtils) {
        return new ZookeeperDiscoveryProperties(inetUtils);
    }

    @Bean
    @ConditionalOnBean(value={ZookeeperServiceDiscovery.class})
    public ZookeeperDiscoveryClient zookeeperDiscoveryClientDeprecated(ZookeeperServiceDiscovery zookeeperServiceDiscovery) {
        return new ZookeeperDiscoveryClient(zookeeperServiceDiscovery, this.zookeeperDependencies);
    }

    @Bean
    @ConditionalOnMissingBean(value={ZookeeperServiceDiscovery.class})
    public ZookeeperDiscoveryClient zookeeperDiscoveryClient(ServiceDiscovery<ZookeeperInstance> serviceDiscovery) {
        return new ZookeeperDiscoveryClient(serviceDiscovery, this.zookeeperDependencies);
    }

    @Bean
    public ZookeeperServiceWatch zookeeperServiceWatch(ZookeeperDiscoveryProperties zookeeperDiscoveryProperties) {
        return new ZookeeperServiceWatch(this.curator, zookeeperDiscoveryProperties);
    }

    @Configuration
    @ConditionalOnClass(value={Endpoint.class})
    protected static class ZookeeperDiscoveryHealthConfig {
        @Autowired(required=false)
        private ZookeeperDependencies zookeeperDependencies;

        protected ZookeeperDiscoveryHealthConfig() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnBean(value={ZookeeperServiceDiscovery.class})
        public ZookeeperDiscoveryHealthIndicator zookeeperDiscoveryHealthIndicatorDeprecated(ZookeeperServiceDiscovery serviceDiscovery, ZookeeperDiscoveryProperties properties) {
            return new ZookeeperDiscoveryHealthIndicator(serviceDiscovery, this.zookeeperDependencies, properties);
        }

        @Bean
        @ConditionalOnMissingBean(value={ZookeeperDiscoveryHealthIndicator.class, ZookeeperServiceDiscovery.class})
        public ZookeeperDiscoveryHealthIndicator zookeeperDiscoveryHealthIndicator(CuratorFramework curatorFramework, ServiceDiscovery<ZookeeperInstance> serviceDiscovery, ZookeeperDiscoveryProperties properties) {
            return new ZookeeperDiscoveryHealthIndicator(curatorFramework, serviceDiscovery, this.zookeeperDependencies, properties);
        }
    }
}

