/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.zookeeper.serviceregistry;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.x.discovery.ServiceDiscovery;
import org.apache.curator.x.discovery.ServiceInstance;
import org.apache.curator.x.discovery.details.InstanceSerializer;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.cloud.client.serviceregistry.ServiceRegistry;
import org.springframework.cloud.zookeeper.discovery.ZookeeperDiscoveryProperties;
import org.springframework.cloud.zookeeper.discovery.ZookeeperInstance;
import org.springframework.cloud.zookeeper.discovery.ZookeeperServiceDiscovery;
import org.springframework.cloud.zookeeper.serviceregistry.ZookeeperRegistration;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class ZookeeperServiceRegistry
implements ServiceRegistry<ZookeeperRegistration>,
SmartInitializingSingleton,
Closeable {
    private ZookeeperServiceDiscovery zookeeperServiceDiscovery;
    private AtomicBoolean started = new AtomicBoolean();
    protected CuratorFramework curator;
    protected ZookeeperDiscoveryProperties properties;
    protected InstanceSerializer<ZookeeperInstance> instanceSerializer;
    private ServiceDiscovery<ZookeeperInstance> serviceDiscovery;

    @Deprecated
    public ZookeeperServiceRegistry(ZookeeperServiceDiscovery zookeeperServiceDiscovery, CuratorFramework curator, ZookeeperDiscoveryProperties properties, InstanceSerializer<ZookeeperInstance> instanceSerializer) {
        this.zookeeperServiceDiscovery = zookeeperServiceDiscovery;
        this.curator = curator;
        this.properties = properties;
        this.instanceSerializer = instanceSerializer;
        this.configureServiceDiscovery();
    }

    public ZookeeperServiceRegistry(ServiceDiscovery<ZookeeperInstance> serviceDiscovery) {
        this.serviceDiscovery = serviceDiscovery;
    }

    private void configureServiceDiscovery() {
        this.zookeeperServiceDiscovery.configureServiceDiscovery(this.zookeeperServiceDiscovery.getServiceDiscoveryRef(), this.curator, this.properties, this.instanceSerializer, this.zookeeperServiceDiscovery.getServiceInstanceRef());
    }

    public void register(ZookeeperRegistration registration) {
        try {
            this.getServiceDiscovery().registerService(registration.getServiceInstance());
        }
        catch (Exception e) {
            ReflectionUtils.rethrowRuntimeException((Throwable)e);
        }
    }

    private ServiceDiscovery<ZookeeperInstance> getServiceDiscovery() {
        if (this.serviceDiscovery != null) {
            return this.serviceDiscovery;
        }
        return this.zookeeperServiceDiscovery.getServiceDiscoveryRef().get();
    }

    public void deregister(ZookeeperRegistration registration) {
        try {
            this.getServiceDiscovery().unregisterService(registration.getServiceInstance());
        }
        catch (Exception e) {
            ReflectionUtils.rethrowRuntimeException((Throwable)e);
        }
    }

    public void afterSingletonsInstantiated() {
        try {
            this.getServiceDiscovery().start();
        }
        catch (Exception e) {
            ReflectionUtils.rethrowRuntimeException((Throwable)e);
        }
    }

    @Override
    public void close() {
        try {
            this.getServiceDiscovery().close();
        }
        catch (IOException e) {
            ReflectionUtils.rethrowRuntimeException((Throwable)e);
        }
    }

    public void setStatus(ZookeeperRegistration registration, String status) {
        ServiceInstance<ZookeeperInstance> serviceInstance = registration.getServiceInstance();
        ZookeeperInstance instance = (ZookeeperInstance)serviceInstance.getPayload();
        instance.getMetadata().put("instance_status", status);
        try {
            this.getServiceDiscovery().updateService(serviceInstance);
        }
        catch (Exception e) {
            ReflectionUtils.rethrowRuntimeException((Throwable)e);
        }
    }

    public Object getStatus(ZookeeperRegistration registration) {
        ZookeeperInstance instance = (ZookeeperInstance)registration.getServiceInstance().getPayload();
        String instanceStatus = instance.getMetadata().get("instance_status");
        if (!StringUtils.hasText((String)instanceStatus)) {
            instanceStatus = "UP";
        }
        return instanceStatus;
    }

    @Deprecated
    public CuratorFramework getCurator() {
        return this.curator;
    }

    @Deprecated
    public AtomicReference<ServiceDiscovery<ZookeeperInstance>> getServiceDiscoveryRef() {
        return this.zookeeperServiceDiscovery.getServiceDiscoveryRef();
    }
}

