/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.zookeeper.discovery;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.client.discovery.AbstractDiscoveryLifecycle;
import org.springframework.cloud.zookeeper.discovery.ZookeeperDiscoveryProperties;
import org.springframework.cloud.zookeeper.discovery.ZookeeperServiceDiscovery;
import org.springframework.util.ReflectionUtils;

public class ZookeeperLifecycle
extends AbstractDiscoveryLifecycle {
    private static final Log log = LogFactory.getLog(ZookeeperLifecycle.class);
    private ZookeeperDiscoveryProperties properties;
    private ZookeeperServiceDiscovery serviceDiscovery;

    public ZookeeperLifecycle(ZookeeperDiscoveryProperties properties, ZookeeperServiceDiscovery serviceDiscovery) {
        this.properties = properties;
        this.serviceDiscovery = serviceDiscovery;
        if (this.properties.getInstancePort() != null) {
            this.serviceDiscovery.setPort(this.properties.getInstancePort());
            this.serviceDiscovery.build();
        }
        this.serviceDiscovery.buildServiceDiscovery();
    }

    protected void register() {
        if (!this.properties.isRegister()) {
            log.debug((Object)"Registration disabled.");
            return;
        }
        try {
            this.serviceDiscovery.getServiceDiscovery().start();
        }
        catch (Exception e) {
            ReflectionUtils.rethrowRuntimeException((Throwable)e);
        }
    }

    protected void deregister() {
        if (!this.properties.isRegister()) {
            return;
        }
        try {
            this.serviceDiscovery.getServiceDiscovery().unregisterService(this.serviceDiscovery.getServiceInstance());
        }
        catch (Exception e) {
            ReflectionUtils.rethrowRuntimeException((Throwable)e);
        }
    }

    protected boolean isEnabled() {
        return this.properties.isEnabled();
    }

    protected int getConfiguredPort() {
        return this.serviceDiscovery.getPort();
    }

    protected void setConfiguredPort(int port) {
        this.serviceDiscovery.setPort(port);
        this.serviceDiscovery.build();
        this.serviceDiscovery.buildServiceDiscovery();
    }

    protected Object getConfiguration() {
        return this.properties;
    }
}

