/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.zookeeper.discovery;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.curator.x.discovery.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.zookeeper.discovery.ZookeeperInstance;
import org.springframework.cloud.zookeeper.discovery.ZookeeperServiceDiscovery;
import org.springframework.cloud.zookeeper.discovery.ZookeeperServiceInstance;
import org.springframework.cloud.zookeeper.discovery.dependency.ZookeeperDependencies;
import org.springframework.util.ReflectionUtils;

public class ZookeeperDiscoveryClient
implements DiscoveryClient {
    private static final Log log = LogFactory.getLog(ZookeeperDiscoveryClient.class);
    private ZookeeperServiceDiscovery serviceDiscovery;
    private ZookeeperDependencies zookeeperDependencies;

    public ZookeeperDiscoveryClient(ZookeeperServiceDiscovery serviceDiscovery, ZookeeperDependencies zookeeperDependencies) {
        this.serviceDiscovery = serviceDiscovery;
        this.zookeeperDependencies = zookeeperDependencies;
    }

    public String description() {
        return "Spring Cloud Zookeeper Discovery Client";
    }

    public org.springframework.cloud.client.ServiceInstance getLocalServiceInstance() {
        ServiceInstance<ZookeeperInstance> serviceInstance = this.serviceDiscovery.getServiceInstance();
        return serviceInstance == null ? null : ZookeeperDiscoveryClient.createServiceInstance(serviceInstance.getName(), serviceInstance);
    }

    private static org.springframework.cloud.client.ServiceInstance createServiceInstance(String serviceId, ServiceInstance<ZookeeperInstance> serviceInstance) {
        return new ZookeeperServiceInstance(serviceId, serviceInstance);
    }

    public List<org.springframework.cloud.client.ServiceInstance> getInstances(String serviceId) {
        try {
            if (this.serviceDiscovery.getServiceDiscovery() == null) {
                return Collections.EMPTY_LIST;
            }
            String serviceIdToQuery = this.getServiceIdToQuery(serviceId);
            Collection zkInstances = this.serviceDiscovery.getServiceDiscovery().queryForInstances(serviceIdToQuery);
            ArrayList<org.springframework.cloud.client.ServiceInstance> instances = new ArrayList<org.springframework.cloud.client.ServiceInstance>();
            for (ServiceInstance instance : zkInstances) {
                instances.add(ZookeeperDiscoveryClient.createServiceInstance(serviceIdToQuery, (ServiceInstance<ZookeeperInstance>)instance));
            }
            return instances;
        }
        catch (Exception exception) {
            ReflectionUtils.rethrowRuntimeException((Throwable)exception);
            return new ArrayList<org.springframework.cloud.client.ServiceInstance>();
        }
    }

    private String getServiceIdToQuery(String serviceId) {
        if (this.zookeeperDependencies != null && this.zookeeperDependencies.hasDependencies()) {
            String pathForAlias = this.zookeeperDependencies.getPathForAlias(serviceId);
            return pathForAlias.isEmpty() ? serviceId : pathForAlias;
        }
        return serviceId;
    }

    public List<String> getServices() {
        ArrayList services = null;
        if (this.serviceDiscovery.getServiceDiscovery() == null) {
            log.warn((Object)"Service Discovery is not yet ready - returning empty list of services");
            return Collections.emptyList();
        }
        try {
            services = new ArrayList(this.serviceDiscovery.getServiceDiscovery().queryForNames());
        }
        catch (Exception e) {
            ReflectionUtils.rethrowRuntimeException((Throwable)e);
        }
        return services;
    }
}

