/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.zookeeper.discovery;

import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.AbstractServerList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.curator.x.discovery.ServiceDiscovery;
import org.apache.curator.x.discovery.ServiceInstance;
import org.springframework.cloud.zookeeper.discovery.ZookeeperInstance;
import org.springframework.cloud.zookeeper.discovery.ZookeeperServer;
import org.springframework.cloud.zookeeper.discovery.dependency.ZookeeperDependencies;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class ZookeeperServerList
extends AbstractServerList<ZookeeperServer> {
    private String serviceId;
    private final ServiceDiscovery<ZookeeperInstance> serviceDiscovery;

    public ZookeeperServerList(ServiceDiscovery<ZookeeperInstance> serviceDiscovery) {
        this.serviceDiscovery = serviceDiscovery;
    }

    public void initWithNiwsConfig(IClientConfig clientConfig) {
        this.serviceId = clientConfig.getClientName();
    }

    public void initFromDependencies(IClientConfig clientConfig, ZookeeperDependencies zookeeperDependencies) {
        this.serviceId = this.getServiceIdFromDepsOrClientName(clientConfig, zookeeperDependencies);
    }

    private String getServiceIdFromDepsOrClientName(IClientConfig clientConfig, ZookeeperDependencies zookeeperDependencies) {
        String serviceIdFromDeps = zookeeperDependencies.getPathForAlias(clientConfig.getClientName());
        return StringUtils.hasText((String)serviceIdFromDeps) ? serviceIdFromDeps : clientConfig.getClientName();
    }

    public List<ZookeeperServer> getInitialListOfServers() {
        return this.getServers();
    }

    public List<ZookeeperServer> getUpdatedListOfServers() {
        return this.getServers();
    }

    private List<ZookeeperServer> getServers() {
        try {
            Collection instances = this.serviceDiscovery.queryForInstances(this.serviceId);
            if (instances == null || instances.isEmpty()) {
                return Collections.EMPTY_LIST;
            }
            ArrayList<ZookeeperServer> servers = new ArrayList<ZookeeperServer>();
            for (ServiceInstance instance : instances) {
                servers.add(new ZookeeperServer((ServiceInstance<ZookeeperInstance>)instance));
            }
            return servers;
        }
        catch (Exception e) {
            ReflectionUtils.rethrowRuntimeException((Throwable)e);
            return Collections.EMPTY_LIST;
        }
    }
}

