/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.zookeeper.discovery;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.cloud.zookeeper.discovery.ZookeeperDiscoveryProperties;
import org.springframework.cloud.zookeeper.discovery.ZookeeperServiceDiscovery;
import org.springframework.cloud.zookeeper.discovery.ZookeeperServiceInstances;
import org.springframework.cloud.zookeeper.discovery.dependency.ZookeeperDependencies;

public class ZookeeperDiscoveryHealthIndicator
extends AbstractHealthIndicator {
    private static final Log log = LogFactory.getLog(ZookeeperDiscoveryHealthIndicator.class);
    private ZookeeperServiceDiscovery serviceDiscovery;
    private ZookeeperDependencies zookeeperDependencies;
    private ZookeeperDiscoveryProperties zookeeperDiscoveryProperties;

    public ZookeeperDiscoveryHealthIndicator(ZookeeperServiceDiscovery serviceDiscovery, ZookeeperDependencies zookeeperDependencies, ZookeeperDiscoveryProperties zookeeperDiscoveryProperties) {
        this.serviceDiscovery = serviceDiscovery;
        this.zookeeperDependencies = zookeeperDependencies;
        this.zookeeperDiscoveryProperties = zookeeperDiscoveryProperties;
    }

    protected void doHealthCheck(Health.Builder builder) throws Exception {
        try {
            ZookeeperServiceInstances allInstances = new ZookeeperServiceInstances(this.serviceDiscovery, this.zookeeperDependencies, this.zookeeperDiscoveryProperties);
            builder.up().withDetail("services", (Object)allInstances);
        }
        catch (Exception e) {
            log.error((Object)"Error", (Throwable)e);
            builder.down(e);
        }
    }
}

