/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.zookeeper.discovery;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.curator.x.discovery.ServiceInstance;
import org.springframework.cloud.zookeeper.discovery.ZookeeperDiscoveryProperties;
import org.springframework.cloud.zookeeper.discovery.ZookeeperInstance;
import org.springframework.cloud.zookeeper.discovery.ZookeeperServiceDiscovery;
import org.springframework.cloud.zookeeper.discovery.dependency.ZookeeperDependencies;

public class ZookeeperServiceInstances
implements Iterable<ServiceInstance<ZookeeperInstance>> {
    private static final Log log = LogFactory.getLog(ZookeeperServiceInstances.class);
    private final ZookeeperServiceDiscovery serviceDiscovery;
    private final ZookeeperDependencies zookeeperDependencies;
    private final ZookeeperDiscoveryProperties zookeeperDiscoveryProperties;
    private final List<ServiceInstance<ZookeeperInstance>> allInstances;

    public ZookeeperServiceInstances(ZookeeperServiceDiscovery serviceDiscovery, ZookeeperDependencies zookeeperDependencies, ZookeeperDiscoveryProperties zookeeperDiscoveryProperties) {
        this.serviceDiscovery = serviceDiscovery;
        this.zookeeperDependencies = zookeeperDependencies;
        this.zookeeperDiscoveryProperties = zookeeperDiscoveryProperties;
        this.allInstances = this.getZookeeperInstances();
    }

    private List<ServiceInstance<ZookeeperInstance>> getZookeeperInstances() {
        ArrayList<ServiceInstance<ZookeeperInstance>> allInstances = new ArrayList<ServiceInstance<ZookeeperInstance>>();
        try {
            Collection<String> names = this.getNamesToQuery();
            for (String name : names) {
                allInstances.addAll(this.nestedInstances(allInstances, name));
            }
            return allInstances;
        }
        catch (Exception e) {
            log.debug((Object)"Exception occurred while trying to build the list of instances", (Throwable)e);
            return allInstances;
        }
    }

    private List<ServiceInstance<ZookeeperInstance>> nestedInstances(List<ServiceInstance<ZookeeperInstance>> accumulator, String name) throws Exception {
        String parentPath = this.prepareQueryName(name);
        Collection<ServiceInstance<ZookeeperInstance>> childrenInstances = this.tryToGetInstances(parentPath);
        if (childrenInstances != null) {
            return this.convertCollectionToList(childrenInstances);
        }
        try {
            List children = (List)this.serviceDiscovery.getCurator().getChildren().forPath(parentPath);
            return this.iterateOverChildren(accumulator, parentPath, children);
        }
        catch (Exception e) {
            log.trace((Object)("Exception occurred while trying to retrieve children of [" + parentPath + "]"), (Throwable)e);
            return this.injectZookeeperServiceInstances(accumulator, parentPath);
        }
    }

    private String prepareQueryName(String name) {
        if (name.startsWith(this.zookeeperDiscoveryProperties.getRoot())) {
            return name;
        }
        String queryName = this.zookeeperDiscoveryProperties.getRoot();
        if (!queryName.endsWith("/")) {
            queryName = String.valueOf(queryName) + "/";
        }
        return String.valueOf(queryName) + name;
    }

    private Collection<ServiceInstance<ZookeeperInstance>> tryToGetInstances(String path) {
        try {
            return this.serviceDiscovery.getServiceDiscovery().queryForInstances(path.substring(this.zookeeperDiscoveryProperties.getRoot().length()));
        }
        catch (Exception e) {
            log.trace((Object)("Exception occurred while trying to retrieve instances of [" + path + "]"), (Throwable)e);
            return null;
        }
    }

    private List<ServiceInstance<ZookeeperInstance>> injectZookeeperServiceInstances(List<ServiceInstance<ZookeeperInstance>> accumulator, String name) throws Exception {
        Collection instances = this.serviceDiscovery.getServiceDiscovery().queryForInstances(name);
        accumulator.addAll(this.convertCollectionToList(instances));
        return accumulator;
    }

    private List<ServiceInstance<ZookeeperInstance>> convertCollectionToList(Collection<ServiceInstance<ZookeeperInstance>> instances) {
        ArrayList<ServiceInstance<ZookeeperInstance>> serviceInstances = new ArrayList<ServiceInstance<ZookeeperInstance>>();
        for (ServiceInstance<ZookeeperInstance> instance : instances) {
            serviceInstances.add(instance);
        }
        return serviceInstances;
    }

    private List<ServiceInstance<ZookeeperInstance>> iterateOverChildren(List<ServiceInstance<ZookeeperInstance>> accumulator, String parentPath, List<String> children) throws Exception {
        ArrayList<ServiceInstance<ZookeeperInstance>> lists = new ArrayList<ServiceInstance<ZookeeperInstance>>();
        for (String child : children) {
            lists.addAll(this.nestedInstances(accumulator, String.valueOf(parentPath) + "/" + child));
        }
        return lists;
    }

    private Collection<String> getNamesToQuery() throws Exception {
        if (this.zookeeperDependencies == null) {
            return this.serviceDiscovery.getServiceDiscovery().queryForNames();
        }
        return this.zookeeperDependencies.getDependencyNames();
    }

    @Override
    public Iterator<ServiceInstance<ZookeeperInstance>> iterator() {
        return this.allInstances.iterator();
    }
}

