/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.zookeeper.config;

import org.springframework.boot.diagnostics.AbstractFailureAnalyzer;
import org.springframework.boot.diagnostics.FailureAnalysis;
import org.springframework.cloud.commons.ConfigDataMissingEnvironmentPostProcessor;
import org.springframework.cloud.util.PropertyUtils;
import org.springframework.core.env.Environment;

public class ZookeeperConfigDataMissingEnvironmentPostProcessor
extends ConfigDataMissingEnvironmentPostProcessor {
    public static final int ORDER = -2147482638;

    public int getOrder() {
        return -2147482638;
    }

    protected boolean shouldProcessEnvironment(Environment environment) {
        if (PropertyUtils.bootstrapEnabled((Environment)environment) || PropertyUtils.useLegacyProcessing((Environment)environment)) {
            return false;
        }
        boolean coreEnabled = (Boolean)environment.getProperty("spring.cloud.zookeeper.enabled", Boolean.class, (Object)true);
        boolean configEnabled = (Boolean)environment.getProperty("spring.cloud.zookeeper.config.enabled", Boolean.class, (Object)true);
        boolean importCheckEnabled = (Boolean)environment.getProperty("spring.cloud.zookeeper.config.import-check.enabled", Boolean.class, (Object)true);
        return coreEnabled && configEnabled && importCheckEnabled;
    }

    protected String getPrefix() {
        return "zookeeper:";
    }

    static class ImportExceptionFailureAnalyzer
    extends AbstractFailureAnalyzer<ConfigDataMissingEnvironmentPostProcessor.ImportException> {
        ImportExceptionFailureAnalyzer() {
        }

        protected FailureAnalysis analyze(Throwable rootFailure, ConfigDataMissingEnvironmentPostProcessor.ImportException cause) {
            String description = cause.missingPrefix ? "The spring.config.import property is missing a zookeeper: entry" : "No spring.config.import property has been defined";
            String action = "Add a spring.config.import=zookeeper: property to your configuration.\n\tIf configuration is not required add spring.config.import=optional:zookeeper: instead.\n\tTo disable this check, set spring.cloud.zookeeper.config.enabled=false or \n\tspring.cloud.zookeeper.config.import-check.enabled=false.";
            return new FailureAnalysis(description, action, (Throwable)cause);
        }
    }
}

