/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.zookeeper.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.curator.framework.CuratorFramework;
import org.springframework.boot.context.config.ConfigData;
import org.springframework.boot.context.config.ConfigDataLoader;
import org.springframework.boot.context.config.ConfigDataLoaderContext;
import org.springframework.boot.context.config.ConfigDataResource;
import org.springframework.boot.context.config.ConfigDataResourceNotFoundException;
import org.springframework.cloud.zookeeper.config.ZookeeperConfigDataResource;
import org.springframework.cloud.zookeeper.config.ZookeeperPropertySource;
import org.springframework.util.StringUtils;

public class ZookeeperConfigDataLoader
implements ConfigDataLoader<ZookeeperConfigDataResource> {
    private static final EnumSet<ConfigData.Option> ALL_OPTIONS = EnumSet.allOf(ConfigData.Option.class);
    private final Log log;

    public ZookeeperConfigDataLoader(Log log) {
        this.log = log;
    }

    public ConfigData load(ConfigDataLoaderContext context, ZookeeperConfigDataResource resource) {
        try {
            CuratorFramework curator = (CuratorFramework)context.getBootstrapContext().get(CuratorFramework.class);
            if (curator == null) {
                return null;
            }
            ZookeeperPropertySource propertySource = new ZookeeperPropertySource(resource.getContext(), curator);
            List<ZookeeperPropertySource> propertySources = Collections.singletonList(propertySource);
            if (ALL_OPTIONS.size() == 1) {
                return new ConfigData(propertySources, new ConfigData.Option[0]);
            }
            if (ALL_OPTIONS.size() == 2) {
                return new ConfigData(propertySources, new ConfigData.Option[]{ConfigData.Option.IGNORE_IMPORTS, ConfigData.Option.IGNORE_PROFILES});
            }
            if (ALL_OPTIONS.size() > 2) {
                return new ConfigData(propertySources, source -> {
                    ArrayList<ConfigData.Option> options = new ArrayList<ConfigData.Option>();
                    options.add(ConfigData.Option.IGNORE_IMPORTS);
                    options.add(ConfigData.Option.IGNORE_PROFILES);
                    if (StringUtils.hasText((String)resource.getProfile())) {
                        options.add(ConfigData.Option.PROFILE_SPECIFIC);
                    }
                    return ConfigData.Options.of((ConfigData.Option[])options.toArray(new ConfigData.Option[0]));
                });
            }
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Error getting properties from zookeeper: " + (Object)((Object)resource)), (Throwable)e);
            }
            throw new ConfigDataResourceNotFoundException((ConfigDataResource)resource, (Throwable)e);
        }
        return null;
    }
}

