/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.zookeeper.config;

import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.curator.framework.CuratorFramework;
import org.apache.zookeeper.KeeperException;
import org.springframework.cloud.zookeeper.config.AbstractZookeeperPropertySource;
import org.springframework.util.ReflectionUtils;

public class ZookeeperPropertySource
extends AbstractZookeeperPropertySource {
    private static final Log log = LogFactory.getLog(ZookeeperPropertySource.class);
    private Map<String, String> properties = new LinkedHashMap<String, String>();

    public ZookeeperPropertySource(String context, CuratorFramework source) {
        super(context, source);
        this.findProperties(this.getContext());
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    private byte[] getPropertyBytes(String fullPath) {
        try {
            byte[] bytes;
            block4: {
                bytes = null;
                try {
                    bytes = (byte[])((CuratorFramework)this.getSource()).getData().forPath(fullPath);
                }
                catch (KeeperException e) {
                    if (e.code() == KeeperException.Code.NONODE) break block4;
                    throw e;
                }
            }
            return bytes;
        }
        catch (Exception exception) {
            ReflectionUtils.rethrowRuntimeException((Throwable)exception);
            return null;
        }
    }

    public String[] getPropertyNames() {
        Set<String> strings = this.properties.keySet();
        return strings.toArray(new String[strings.size()]);
    }

    private void findProperties(String path) {
        try {
            List children;
            block7: {
                log.trace((Object)("entering findProperties for path: " + path));
                children = null;
                try {
                    children = (List)((CuratorFramework)this.getSource()).getChildren().forPath(path);
                }
                catch (KeeperException e) {
                    if (e.code() == KeeperException.Code.NONODE) break block7;
                    throw e;
                }
            }
            if (children == null || children.isEmpty()) {
                return;
            }
            for (String child : children) {
                String childPath = String.valueOf(path) + "/" + child;
                byte[] bytes = this.getPropertyBytes(childPath);
                if (bytes == null || bytes.length == 0) {
                    this.findProperties(childPath);
                    continue;
                }
                String key = this.sanitizeKey(childPath);
                this.properties.put(key, new String(bytes, Charset.forName("UTF-8")));
            }
            log.trace((Object)("leaving findProperties for path: " + path));
        }
        catch (Exception exception) {
            ReflectionUtils.rethrowRuntimeException((Throwable)exception);
        }
    }
}

