/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.vault.config;

import java.util.Map;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.health.autoconfigure.contributor.CompositeHealthContributorConfiguration;
import org.springframework.boot.health.contributor.HealthContributor;
import org.springframework.cloud.vault.config.VaultHealthIndicator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.vault.core.VaultOperations;

@Configuration(proxyBeanMethods=false)
@ConditionalOnBean(value={VaultOperations.class})
class VaultHealthIndicatorConfiguration
extends CompositeHealthContributorConfiguration<VaultHealthIndicator, VaultOperations> {
    private final Map<String, VaultOperations> vaultTemplates;

    VaultHealthIndicatorConfiguration(Map<String, VaultOperations> vaultTemplates) {
        super(VaultHealthIndicator::new);
        this.vaultTemplates = vaultTemplates;
    }

    @Bean
    @ConditionalOnMissingBean(name={"vaultHealthIndicator"})
    public HealthContributor vaultHealthIndicator() {
        return (HealthContributor)this.createContributor(this.vaultTemplates);
    }
}

