/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.vault.config;

import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.discovery.ReactiveDiscoveryClient;
import org.springframework.cloud.commons.util.UtilAutoConfiguration;
import org.springframework.cloud.vault.config.ReacvtiveDiscoveryClientVaultServiceInstanceProvider;
import org.springframework.cloud.vault.config.VaultConfiguration;
import org.springframework.cloud.vault.config.VaultProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;
import org.springframework.vault.client.ReactiveVaultEndpointProvider;
import org.springframework.vault.client.VaultEndpointProvider;
import org.springframework.vault.core.ReactiveVaultOperations;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(value={"spring.cloud.vault.discovery.enabled"})
@ConditionalOnExpression(value="${spring.cloud.vault.reactive.enabled:true}")
@ConditionalOnClass(value={Flux.class, WebClient.class, ReactiveVaultOperations.class, ReactiveDiscoveryClient.class})
@EnableConfigurationProperties(value={VaultProperties.class})
@Order(value=0x7FFFFFFA)
@Import(value={UtilAutoConfiguration.class})
public class ReactiveDiscoveryClientVaultBootstrapConfiguration {
    private final VaultProperties vaultProperties;
    private final VaultConfiguration configuration;

    public ReactiveDiscoveryClientVaultBootstrapConfiguration(VaultProperties vaultProperties) {
        this.vaultProperties = vaultProperties;
        this.configuration = new VaultConfiguration(vaultProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(name={"spring.cloud.vault.enabled"}, matchIfMissing=true)
    public ReactiveVaultEndpointProvider reactiveVaultEndpointProvider(ObjectProvider<ReactiveDiscoveryClient> reactiveDiscoveryClients, ObjectProvider<VaultEndpointProvider> endpointProviders) {
        ReactiveDiscoveryClient reactiveDiscoveryClient = (ReactiveDiscoveryClient)reactiveDiscoveryClients.getIfAvailable();
        if (reactiveDiscoveryClient != null) {
            ReacvtiveDiscoveryClientVaultServiceInstanceProvider instanceProvider = new ReacvtiveDiscoveryClientVaultServiceInstanceProvider(reactiveDiscoveryClient);
            return () -> Mono.defer(() -> {
                String serviceId = this.vaultProperties.getDiscovery().getServiceId();
                return instanceProvider.getVaultServerInstance(serviceId).map(this.configuration::createVaultEndpoint);
            });
        }
        VaultEndpointProvider endpointProvider = (VaultEndpointProvider)endpointProviders.getObject();
        return () -> Mono.fromSupplier(() -> ((VaultEndpointProvider)endpointProvider).getVaultEndpoint()).subscribeOn(Schedulers.boundedElastic());
    }
}

