/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.vault.config.consul;

import java.util.LinkedHashMap;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.vault.config.SecretBackendMetadata;
import org.springframework.cloud.vault.config.SecretBackendMetadataFactory;
import org.springframework.cloud.vault.config.VaultSecretBackendDescriptor;
import org.springframework.cloud.vault.config.consul.ConsulBackendMetadata;
import org.springframework.cloud.vault.config.consul.VaultConsulProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.Assert;
import org.springframework.vault.core.util.PropertyTransformer;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={VaultConsulProperties.class})
public class VaultConfigConsulBootstrapConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public ConsulSecretBackendMetadataFactory consulSecretBackendMetadataFactory(ApplicationContext context) {
        return new ConsulSecretBackendMetadataFactory(context);
    }

    public static class ConsulSecretBackendMetadataFactory
    implements SecretBackendMetadataFactory<VaultConsulProperties> {
        private final ApplicationEventPublisher publisher;

        public ConsulSecretBackendMetadataFactory() {
            this.publisher = event -> {};
        }

        public ConsulSecretBackendMetadataFactory(ApplicationContext publisher) {
            this.publisher = publisher;
        }

        public ApplicationEventPublisher getPublisher() {
            return this.publisher;
        }

        SecretBackendMetadata forConsul(VaultConsulProperties properties) {
            Assert.notNull((Object)properties, (String)"VaultConsulProperties must not be null");
            PropertyTransformer transformer = input -> {
                LinkedHashMap transformed = new LinkedHashMap();
                transformed.put("spring.cloud.consul.config.acl-token", input.get("token"));
                transformed.put("spring.cloud.consul.discovery.acl-token", input.get("token"));
                return transformed;
            };
            return new ConsulBackendMetadata(properties, transformer, this.publisher);
        }

        public SecretBackendMetadata createMetadata(VaultConsulProperties backendDescriptor) {
            return this.forConsul(backendDescriptor);
        }

        public boolean supports(VaultSecretBackendDescriptor backendDescriptor) {
            return backendDescriptor instanceof VaultConsulProperties;
        }
    }
}

