/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.batch.listener;

import org.springframework.batch.core.listener.ChunkListener;
import org.springframework.batch.infrastructure.item.Chunk;
import org.springframework.cloud.task.batch.listener.support.MessagePublisher;
import org.springframework.cloud.task.batch.listener.support.TaskEventProperties;
import org.springframework.core.Ordered;
import org.springframework.util.Assert;

public class EventEmittingChunkListener
implements ChunkListener,
Ordered {
    private int order = Integer.MAX_VALUE;
    private MessagePublisher messagePublisher;
    private TaskEventProperties properties;

    public EventEmittingChunkListener(MessagePublisher messagePublisher, TaskEventProperties properties) {
        Assert.notNull((Object)messagePublisher, (String)"messagePublisher is required");
        Assert.notNull((Object)properties, (String)"properties is required");
        this.messagePublisher = messagePublisher;
        this.properties = properties;
    }

    public EventEmittingChunkListener(MessagePublisher messagePublisher, int order, TaskEventProperties properties) {
        this(messagePublisher, properties);
        this.order = order;
    }

    public void beforeChunk(Chunk chunk) {
        this.messagePublisher.publish(this.properties.getChunkEventBindingName(), "Before Chunk Processing");
    }

    public void afterChunk(Chunk chunk) {
        this.messagePublisher.publish(this.properties.getChunkEventBindingName(), "After Chunk Processing");
    }

    public void onChunkError(Exception exception, Chunk chunk) {
    }

    public int getOrder() {
        return this.order;
    }
}

