/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.batch.listener.support;

import java.lang.reflect.Field;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.batch.core.job.AbstractJob;
import org.springframework.batch.core.listener.ChunkListener;
import org.springframework.batch.core.listener.ItemProcessListener;
import org.springframework.batch.core.listener.ItemReadListener;
import org.springframework.batch.core.listener.ItemWriteListener;
import org.springframework.batch.core.listener.JobExecutionListener;
import org.springframework.batch.core.listener.SkipListener;
import org.springframework.batch.core.listener.StepExecutionListener;
import org.springframework.batch.core.listener.StepListener;
import org.springframework.batch.core.step.AbstractStep;
import org.springframework.batch.core.step.item.ChunkOrientedTasklet;
import org.springframework.batch.core.step.item.SimpleChunkProcessor;
import org.springframework.batch.core.step.item.SimpleChunkProvider;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.core.step.tasklet.TaskletStep;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.ImportRuntimeHints;
import org.springframework.util.ReflectionUtils;

@ImportRuntimeHints(value={RuntimeHint.class})
public class TaskBatchEventListenerBeanPostProcessor
implements BeanPostProcessor {
    @Autowired
    private ApplicationContext applicationContext;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        this.registerJobExecutionEventListener(bean);
        if (bean instanceof AbstractStep) {
            this.registerStepExecutionEventListener(bean);
            if (bean instanceof TaskletStep) {
                TaskletStep taskletStep = (TaskletStep)bean;
                Tasklet tasklet = taskletStep.getTasklet();
                this.registerChunkEventsListener(bean);
                if (tasklet instanceof ChunkOrientedTasklet) {
                    Field chunkProviderField = ReflectionUtils.findField(ChunkOrientedTasklet.class, (String)"chunkProvider");
                    ReflectionUtils.makeAccessible((Field)chunkProviderField);
                    SimpleChunkProvider chunkProvider = (SimpleChunkProvider)ReflectionUtils.getField((Field)chunkProviderField, (Object)tasklet);
                    Field chunkProcessorField = ReflectionUtils.findField(ChunkOrientedTasklet.class, (String)"chunkProcessor");
                    ReflectionUtils.makeAccessible((Field)chunkProcessorField);
                    SimpleChunkProcessor chunkProcessor = (SimpleChunkProcessor)ReflectionUtils.getField((Field)chunkProcessorField, (Object)tasklet);
                    this.registerItemReadEvents(chunkProvider);
                    this.registerSkipEvents(chunkProvider);
                    this.registerItemProcessEvents(chunkProcessor);
                    this.registerItemWriteEvents(chunkProcessor);
                    this.registerSkipEvents(chunkProcessor);
                }
            }
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    private void registerItemProcessEvents(SimpleChunkProcessor chunkProcessor) {
        if (this.applicationContext.containsBean("itemProcessEventsListener")) {
            chunkProcessor.registerListener((StepListener)((ItemProcessListener)this.applicationContext.getBean("itemProcessEventsListener")));
        }
    }

    private void registerItemReadEvents(SimpleChunkProvider chunkProvider) {
        if (this.applicationContext.containsBean("itemReadEventsListener")) {
            chunkProvider.registerListener((StepListener)((ItemReadListener)this.applicationContext.getBean("itemReadEventsListener")));
        }
    }

    private void registerItemWriteEvents(SimpleChunkProcessor chunkProcessor) {
        if (this.applicationContext.containsBean("itemWriteEventsListener")) {
            chunkProcessor.registerListener((StepListener)((ItemWriteListener)this.applicationContext.getBean("itemWriteEventsListener")));
        }
    }

    private void registerSkipEvents(SimpleChunkProvider chunkProvider) {
        if (this.applicationContext.containsBean("skipEventsListener")) {
            chunkProvider.registerListener((StepListener)((SkipListener)this.applicationContext.getBean("skipEventsListener")));
        }
    }

    private void registerSkipEvents(SimpleChunkProcessor chunkProcessor) {
        if (this.applicationContext.containsBean("skipEventsListener")) {
            chunkProcessor.registerListener((StepListener)((SkipListener)this.applicationContext.getBean("skipEventsListener")));
        }
    }

    private void registerChunkEventsListener(Object bean) {
        if (this.applicationContext.containsBean("chunkEventsListener")) {
            ((TaskletStep)bean).registerChunkListener((ChunkListener)this.applicationContext.getBean("chunkEventsListener"));
        }
    }

    private void registerJobExecutionEventListener(Object bean) {
        if (bean instanceof AbstractJob) {
            AbstractJob job = (AbstractJob)bean;
            if (this.applicationContext.containsBean("jobExecutionEventsListener")) {
                JobExecutionListener jobExecutionEventsListener = (JobExecutionListener)this.applicationContext.getBean("jobExecutionEventsListener");
                job.registerJobExecutionListener(jobExecutionEventsListener);
            }
        }
    }

    private void registerStepExecutionEventListener(Object bean) {
        if (this.applicationContext.containsBean("stepExecutionEventsListener")) {
            StepExecutionListener stepExecutionListener = (StepExecutionListener)this.applicationContext.getBean("stepExecutionEventsListener");
            AbstractStep step = (AbstractStep)bean;
            step.registerStepExecutionListener(stepExecutionListener);
        }
    }

    static class RuntimeHint
    implements RuntimeHintsRegistrar {
        RuntimeHint() {
        }

        public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
            hints.reflection().registerType(ChunkOrientedTasklet.class, new MemberCategory[]{MemberCategory.DECLARED_FIELDS});
        }
    }
}

