/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.batch.listener;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.listener.JobExecutionListenerSupport;
import org.springframework.cloud.task.batch.listener.TaskBatchDao;
import org.springframework.cloud.task.listener.annotation.BeforeTask;
import org.springframework.cloud.task.repository.TaskExecution;
import org.springframework.util.Assert;

public class TaskBatchExecutionListener
extends JobExecutionListenerSupport {
    private TaskExecution taskExecution;
    private TaskBatchDao taskBatchDao;
    private static final Log logger = LogFactory.getLog(TaskBatchExecutionListener.class);

    public TaskBatchExecutionListener(TaskBatchDao taskBatchDao) {
        Assert.notNull((Object)taskBatchDao, (String)"A TaskBatchDao is required");
        this.taskBatchDao = taskBatchDao;
    }

    @BeforeTask
    public void onTaskStartup(TaskExecution taskExecution) {
        this.taskExecution = taskExecution;
    }

    public void beforeJob(JobExecution jobExecution) {
        if (this.taskExecution == null) {
            logger.warn((Object)"This job was executed outside the scope of a task but still used the task listener.");
        } else {
            logger.info((Object)String.format("The job execution id %s was run within the task execution %s", jobExecution.getId(), this.taskExecution.getExecutionId()));
            this.taskBatchDao.saveRelationship(this.taskExecution, jobExecution);
        }
    }
}

