/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.function;

import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.function.context.catalog.SimpleFunctionRegistry;
import org.springframework.cloud.stream.binder.PartitionHandler;
import org.springframework.cloud.stream.binder.ProducerProperties;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.messaging.Message;

class PartitionAwareFunctionWrapper
implements Function<Object, Object>,
Supplier<Object> {
    protected final Log logger = LogFactory.getLog(PartitionAwareFunctionWrapper.class);
    private final Function function;
    private final Function<Object, Message> outputMessageEnricher;

    PartitionAwareFunctionWrapper(Function<?, ?> function, ConfigurableApplicationContext context, ProducerProperties producerProperties) {
        this.function = function;
        if (producerProperties != null && producerProperties.isPartitioned()) {
            StandardEvaluationContext evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)context.getBeanFactory());
            PartitionHandler partitionHandler = new PartitionHandler((EvaluationContext)evaluationContext, producerProperties, context.getBeanFactory());
            this.outputMessageEnricher = output -> {
                if (!(output instanceof Message)) {
                    output = MessageBuilder.withPayload((Object)output).build();
                }
                int partitionId = partitionHandler.determinePartition((Message)output);
                return MessageBuilder.fromMessage((Message)((Message)output)).setHeader("scst_partition", (Object)partitionId).build();
            };
        } else {
            this.outputMessageEnricher = null;
        }
    }

    @Override
    public Object apply(Object input) {
        this.setEnhancerIfNecessary();
        return this.function.apply(input);
    }

    @Override
    public Object get() {
        if (this.function instanceof SimpleFunctionRegistry.FunctionInvocationWrapper) {
            this.setEnhancerIfNecessary();
            return ((SimpleFunctionRegistry.FunctionInvocationWrapper)this.function).get();
        }
        throw new IllegalStateException("Call to get() is not allowed since this function is not a Supplier.");
    }

    private void setEnhancerIfNecessary() {
        if (this.function instanceof SimpleFunctionRegistry.FunctionInvocationWrapper) {
            ((SimpleFunctionRegistry.FunctionInvocationWrapper)this.function).setEnhancer(this.outputMessageEnricher);
        }
    }
}

