/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.config;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public interface MergableProperties {
    default public void merge(MergableProperties mergable) {
        if (mergable == null) {
            return;
        }
        for (PropertyDescriptor targetPd : BeanUtils.getPropertyDescriptors(mergable.getClass())) {
            Method readMethod;
            PropertyDescriptor sourcePd;
            Method writeMethod = targetPd.getWriteMethod();
            if (writeMethod == null || (sourcePd = BeanUtils.getPropertyDescriptor(this.getClass(), (String)targetPd.getName())) == null || (readMethod = sourcePd.getReadMethod()) == null || !ClassUtils.isAssignable(writeMethod.getParameterTypes()[0], readMethod.getReturnType())) continue;
            try {
                Object value;
                if (!Modifier.isPublic(readMethod.getDeclaringClass().getModifiers())) {
                    readMethod.setAccessible(true);
                }
                if ((value = readMethod.invoke((Object)this, new Object[0])) == null) continue;
                if (value instanceof MergableProperties) {
                    ((MergableProperties)value).merge((MergableProperties)readMethod.invoke((Object)mergable, new Object[0]));
                    continue;
                }
                Object v = readMethod.invoke((Object)mergable, new Object[0]);
                if (v != null && (!ObjectUtils.isArray((Object)v) || !ObjectUtils.isEmpty((Object)v))) continue;
                if (!Modifier.isPublic(writeMethod.getDeclaringClass().getModifiers())) {
                    writeMethod.setAccessible(true);
                }
                writeMethod.invoke((Object)mergable, value);
            }
            catch (Throwable ex) {
                throw new FatalBeanException("Could not copy property '" + targetPd.getName() + "' from source to target", ex);
            }
        }
    }

    default public void copyProperties(Object source, Object target) throws BeansException {
    }
}

