/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.converter;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.springframework.cloud.stream.converter.MessageConverterUtils;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.AbstractMessageConverter;
import org.springframework.messaging.converter.MessageConversionException;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;

public class JsonUnmarshallingConverter
extends AbstractMessageConverter {
    private final ObjectMapper objectMapper;

    protected JsonUnmarshallingConverter(ObjectMapper objectMapper) {
        super(MessageConverterUtils.X_JAVA_OBJECT);
        this.objectMapper = objectMapper != null ? objectMapper : new ObjectMapper();
    }

    protected boolean supports(Class<?> aClass) {
        return true;
    }

    protected boolean canConvertFrom(Message<?> message, Class<?> targetClass) {
        if (message.getPayload() instanceof String || message.getPayload() instanceof byte[]) {
            return true;
        }
        return this.canConvertFromBasedOnContentTypeHeader(message);
    }

    private boolean canConvertFromBasedOnContentTypeHeader(Message<?> message) {
        Object contentTypeHeader = message.getHeaders().get((Object)"contentType");
        if (contentTypeHeader instanceof String) {
            return MimeTypeUtils.APPLICATION_JSON.includes(MimeTypeUtils.parseMimeType((String)((String)contentTypeHeader)));
        }
        if (contentTypeHeader instanceof MimeType) {
            return MimeTypeUtils.APPLICATION_JSON.includes((MimeType)contentTypeHeader);
        }
        return contentTypeHeader == null;
    }

    protected Object convertFromInternal(Message<?> message, Class<?> targetClass, Object conversionHint) {
        Object payload = message.getPayload();
        try {
            return payload instanceof byte[] ? this.objectMapper.readValue((byte[])payload, targetClass) : this.objectMapper.readValue((String)payload, targetClass);
        }
        catch (IOException e) {
            throw new MessageConversionException("Cannot parse payload ", (Throwable)e);
        }
    }

    protected Object convertToInternal(Object payload, MessageHeaders headers, Object conversionHint) {
        return super.convertToInternal(payload, headers, conversionHint);
    }
}

