/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binding;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.springframework.cloud.stream.binding.BindableAdapter;
import org.springframework.cloud.stream.binding.BindingService;

public class SingleBindingTargetBindable<T>
extends BindableAdapter {
    private final String name;
    private final T bindingTarget;

    public SingleBindingTargetBindable(String name, T bindingTarget) {
        this.name = name;
        this.bindingTarget = bindingTarget;
    }

    @Override
    public void bindOutputs(BindingService bindingService) {
        bindingService.bindProducer(this.bindingTarget, this.name);
    }

    @Override
    public void unbindOutputs(BindingService bindingService) {
        bindingService.unbindProducers(this.name);
    }

    @Override
    public Set<String> getOutputs() {
        return Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(this.name)));
    }
}

