/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.converter;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.springframework.cloud.stream.converter.AbstractFromMessageConverter;
import org.springframework.cloud.stream.converter.ByteArrayToStringMessageConverter;
import org.springframework.cloud.stream.converter.ConversionException;
import org.springframework.cloud.stream.converter.JavaToSerializedMessageConverter;
import org.springframework.cloud.stream.converter.JsonToPojoMessageConverter;
import org.springframework.cloud.stream.converter.JsonToTupleMessageConverter;
import org.springframework.cloud.stream.converter.MessageConverterUtils;
import org.springframework.cloud.stream.converter.PojoToJsonMessageConverter;
import org.springframework.cloud.stream.converter.PojoToStringMessageConverter;
import org.springframework.cloud.stream.converter.SerializedToJavaMessageConverter;
import org.springframework.cloud.stream.converter.StringToByteArrayMessageConverter;
import org.springframework.cloud.stream.converter.TupleToJsonMessageConverter;
import org.springframework.messaging.converter.CompositeMessageConverter;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MimeType;
import org.springframework.util.ObjectUtils;

public class CompositeMessageConverterFactory {
    private final ObjectMapper objectMapper;
    private final List<AbstractFromMessageConverter> converters;

    public CompositeMessageConverterFactory() {
        this(Collections.emptyList(), new ObjectMapper());
    }

    public CompositeMessageConverterFactory(List<? extends AbstractFromMessageConverter> customConverters, ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        this.converters = !CollectionUtils.isEmpty(customConverters) ? new ArrayList<AbstractFromMessageConverter>(customConverters) : new ArrayList<AbstractFromMessageConverter>();
        this.initDefaultConverters();
    }

    private void initDefaultConverters() {
        this.converters.add(new JsonToTupleMessageConverter());
        this.converters.add(new TupleToJsonMessageConverter(this.objectMapper));
        this.converters.add(new JsonToPojoMessageConverter(this.objectMapper));
        this.converters.add(new PojoToJsonMessageConverter(this.objectMapper));
        this.converters.add(new ByteArrayToStringMessageConverter());
        this.converters.add(new StringToByteArrayMessageConverter());
        this.converters.add(new PojoToStringMessageConverter());
        this.converters.add(new JavaToSerializedMessageConverter());
        this.converters.add(new SerializedToJavaMessageConverter());
    }

    public CompositeMessageConverter getMessageConverterForType(MimeType targetMimeType) {
        ArrayList<AbstractFromMessageConverter> targetMimeTypeConverters = new ArrayList<AbstractFromMessageConverter>();
        for (AbstractFromMessageConverter converter : this.converters) {
            if (!converter.supportsTargetMimeType(targetMimeType)) continue;
            targetMimeTypeConverters.add(converter);
        }
        if (CollectionUtils.isEmpty(targetMimeTypeConverters)) {
            throw new ConversionException("No message converter is registered for " + targetMimeType.toString());
        }
        return new CompositeMessageConverter(targetMimeTypeConverters);
    }

    public CompositeMessageConverter getMessageConverterForAllRegistered() {
        return new CompositeMessageConverter(new ArrayList<AbstractFromMessageConverter>(this.converters));
    }

    public Class<?>[] supportedDataTypes(MimeType targetMimeType) {
        HashSet<Object> supportedDataTypes = new HashSet<Object>();
        if (MessageConverterUtils.X_JAVA_OBJECT.includes(targetMimeType)) {
            supportedDataTypes.add(MessageConverterUtils.getJavaTypeForJavaObjectContentType(targetMimeType));
        } else {
            for (AbstractFromMessageConverter converter : this.converters) {
                Object[] targetTypes;
                if (!converter.supportsTargetMimeType(targetMimeType) || ObjectUtils.isEmpty((Object[])(targetTypes = converter.supportedTargetTypes()))) continue;
                supportedDataTypes.addAll(Arrays.asList(targetTypes));
            }
        }
        return supportedDataTypes.toArray(new Class[supportedDataTypes.size()]);
    }
}

