/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.schema.server.support;

import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.SchemaParseException;
import org.springframework.cloud.stream.schema.server.model.Compatibility;
import org.springframework.cloud.stream.schema.server.support.SchemaValidator;

public class AvroSchemaValidator
implements SchemaValidator {
    @Override
    public boolean isValid(String definition) {
        boolean result = true;
        try {
            new Schema.Parser().parse(definition);
        }
        catch (SchemaParseException ex) {
            result = false;
        }
        return result;
    }

    @Override
    public Compatibility compatibilityCheck(String source, String other) {
        return null;
    }

    @Override
    public org.springframework.cloud.stream.schema.server.model.Schema match(List<org.springframework.cloud.stream.schema.server.model.Schema> schemas, String definition) {
        org.springframework.cloud.stream.schema.server.model.Schema result = null;
        Schema source = new Schema.Parser().parse(definition);
        for (org.springframework.cloud.stream.schema.server.model.Schema s : schemas) {
            Schema target = new Schema.Parser().parse(s.getDefinition());
            if (!target.equals((Object)source)) continue;
            result = s;
            break;
        }
        return result;
    }

    @Override
    public String getFormat() {
        return "avro";
    }
}

