/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.schema.registry.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.stream.schema.registry.SchemaNotFoundException;
import org.springframework.cloud.stream.schema.registry.SchemaReference;
import org.springframework.cloud.stream.schema.registry.SchemaRegistrationResponse;
import org.springframework.cloud.stream.schema.registry.client.SchemaRegistryClient;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestTemplate;

public class ConfluentSchemaRegistryClient
implements SchemaRegistryClient {
    private static final List<String> ACCEPT_HEADERS = Arrays.asList("application/vnd.schemaregistry.v1+json", "application/vnd.schemaregistry+json", "application/json");
    private RestTemplate template;
    private String endpoint = "http://localhost:8081";
    private ObjectMapper mapper;

    public ConfluentSchemaRegistryClient() {
        this(new RestTemplate());
    }

    public ConfluentSchemaRegistryClient(RestTemplate template) {
        this(template, new ObjectMapper());
    }

    public ConfluentSchemaRegistryClient(RestTemplate template, ObjectMapper mapper) {
        this.template = template;
        this.mapper = mapper;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    @Override
    public SchemaRegistrationResponse register(String subject, String format, String schema) {
        Assert.isTrue((boolean)"avro".equals(format), (String)"Only Avro is supported");
        HttpHeaders headers = new HttpHeaders();
        headers.put("Accept", ACCEPT_HEADERS);
        headers.add("Content-Type", "application/json");
        Integer version = null;
        Integer id = null;
        String payload = null;
        HashMap<String, String> maps = new HashMap<String, String>();
        maps.put("schema", schema);
        try {
            payload = this.mapper.writeValueAsString(maps);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Could not parse schema, invalid JSON format", e);
        }
        try {
            HttpEntity request = new HttpEntity((Object)payload, (MultiValueMap)headers);
            ResponseEntity response = this.template.exchange(this.endpoint + "/subjects/" + subject + "/versions", HttpMethod.POST, request, Map.class, new Object[0]);
            id = (Integer)((Map)response.getBody()).get("id");
        }
        catch (HttpStatusCodeException httpException) {
            throw new RuntimeException(String.format("Failed to register subject %s, server replied with status %d", subject, httpException.getStatusCode().value()), httpException);
        }
        try {
            ResponseEntity response = this.template.getForEntity(this.endpoint + "/schemas/ids/" + id + "/versions", List.class, new Object[0]);
            List body = (List)response.getBody();
            if (!CollectionUtils.isEmpty((Collection)body)) {
                version = (Integer)((Map)body.get(0)).get("version");
            }
        }
        catch (HttpStatusCodeException httpException) {
            throw new RuntimeException(String.format("Failed to register subject %s, server replied with status %d", subject, httpException.getStatusCode().value()), httpException);
        }
        SchemaRegistrationResponse schemaRegistrationResponse = new SchemaRegistrationResponse();
        schemaRegistrationResponse.setId(id);
        schemaRegistrationResponse.setSchemaReference(new SchemaReference(subject, version, "avro"));
        return schemaRegistrationResponse;
    }

    @Override
    public String fetch(SchemaReference schemaReference) {
        String path = String.format("/subjects/%s/versions/%d", schemaReference.getSubject(), schemaReference.getVersion());
        HttpHeaders headers = new HttpHeaders();
        headers.put("Accept", ACCEPT_HEADERS);
        headers.add("Content-Type", "application/vnd.schemaregistry.v1+json");
        HttpEntity request = new HttpEntity((Object)"", (MultiValueMap)headers);
        try {
            ResponseEntity response = this.template.exchange(this.endpoint + path, HttpMethod.GET, request, Map.class, new Object[0]);
            return (String)((Map)response.getBody()).get("schema");
        }
        catch (HttpStatusCodeException e) {
            if (e.getStatusCode() == HttpStatus.NOT_FOUND) {
                throw new SchemaNotFoundException(String.format("Could not find schema for reference: %s", schemaReference));
            }
            throw e;
        }
    }

    @Override
    public String fetch(int id) {
        String path = String.format("/schemas/ids/%d", id);
        HttpHeaders headers = new HttpHeaders();
        headers.put("Accept", ACCEPT_HEADERS);
        headers.add("Content-Type", "application/vnd.schemaregistry.v1+json");
        HttpEntity request = new HttpEntity((Object)"", (MultiValueMap)headers);
        try {
            ResponseEntity response = this.template.exchange(this.endpoint + path, HttpMethod.GET, request, Map.class, new Object[0]);
            return (String)((Map)response.getBody()).get("schema");
        }
        catch (HttpStatusCodeException e) {
            if (e.getStatusCode() == HttpStatus.NOT_FOUND) {
                throw new SchemaNotFoundException(String.format("Could not find schema with id: %s", id));
            }
            throw e;
        }
    }
}

