/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.rabbit.config;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.amqp.core.DeclarableCustomizer;
import org.springframework.amqp.core.MessagePostProcessor;
import org.springframework.amqp.rabbit.connection.AbstractConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionNameStrategy;
import org.springframework.amqp.rabbit.listener.AbstractMessageListenerContainer;
import org.springframework.amqp.support.postprocessor.DelegatingDecompressingPostProcessor;
import org.springframework.amqp.support.postprocessor.GZipPostProcessor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.amqp.RabbitProperties;
import org.springframework.boot.autoconfigure.context.PropertyPlaceholderAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.binder.rabbit.RabbitMessageChannelBinder;
import org.springframework.cloud.stream.binder.rabbit.properties.RabbitBinderConfigurationProperties;
import org.springframework.cloud.stream.binder.rabbit.properties.RabbitExtendedBindingProperties;
import org.springframework.cloud.stream.binder.rabbit.provisioning.RabbitExchangeQueueProvisioner;
import org.springframework.cloud.stream.config.ConsumerEndpointCustomizer;
import org.springframework.cloud.stream.config.ListenerContainerCustomizer;
import org.springframework.cloud.stream.config.MessageSourceCustomizer;
import org.springframework.cloud.stream.config.ProducerMessageHandlerCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.integration.amqp.inbound.AmqpInboundChannelAdapter;
import org.springframework.integration.amqp.inbound.AmqpMessageSource;
import org.springframework.integration.amqp.outbound.AmqpOutboundEndpoint;
import org.springframework.lang.Nullable;

@Configuration(proxyBeanMethods=false)
@Import(value={PropertyPlaceholderAutoConfiguration.class})
@EnableConfigurationProperties(value={RabbitBinderConfigurationProperties.class, RabbitExtendedBindingProperties.class})
public class RabbitMessageChannelBinderConfiguration {
    @Autowired
    private ConnectionFactory rabbitConnectionFactory;
    @Autowired
    private RabbitProperties rabbitProperties;
    @Autowired
    private RabbitBinderConfigurationProperties rabbitBinderConfigurationProperties;
    @Autowired
    private RabbitExtendedBindingProperties rabbitExtendedBindingProperties;

    @Bean
    RabbitMessageChannelBinder rabbitMessageChannelBinder(@Nullable ListenerContainerCustomizer<AbstractMessageListenerContainer> listenerContainerCustomizer, @Nullable MessageSourceCustomizer<AmqpMessageSource> sourceCustomizer, @Nullable ProducerMessageHandlerCustomizer<AmqpOutboundEndpoint> producerMessageHandlerCustomizer, @Nullable ConsumerEndpointCustomizer<AmqpInboundChannelAdapter> consumerCustomizer, List<DeclarableCustomizer> declarableCustomizers, @Nullable ConnectionNameStrategy connectionNameStrategy, MessagePostProcessor gZipPostProcessor, MessagePostProcessor deCompressingPostProcessor, RabbitExchangeQueueProvisioner provisioningProvider) {
        String connectionNamePrefix = this.rabbitBinderConfigurationProperties.getConnectionNamePrefix();
        if (this.rabbitConnectionFactory instanceof AbstractConnectionFactory && connectionNamePrefix != null && connectionNameStrategy == null) {
            AtomicInteger nameIncrementer = new AtomicInteger();
            ((AbstractConnectionFactory)this.rabbitConnectionFactory).setConnectionNameStrategy(f -> connectionNamePrefix + "#" + nameIncrementer.getAndIncrement());
        }
        RabbitMessageChannelBinder binder = new RabbitMessageChannelBinder(this.rabbitConnectionFactory, this.rabbitProperties, provisioningProvider, listenerContainerCustomizer, sourceCustomizer);
        binder.setAdminAddresses(this.rabbitBinderConfigurationProperties.getAdminAddresses());
        binder.setCompressingPostProcessor(gZipPostProcessor);
        binder.setDecompressingPostProcessor(deCompressingPostProcessor);
        binder.setNodes(this.rabbitBinderConfigurationProperties.getNodes());
        binder.setExtendedBindingProperties(this.rabbitExtendedBindingProperties);
        binder.setProducerMessageHandlerCustomizer(producerMessageHandlerCustomizer);
        binder.setConsumerEndpointCustomizer(consumerCustomizer);
        return binder;
    }

    @Bean
    MessagePostProcessor deCompressingPostProcessor() {
        return new DelegatingDecompressingPostProcessor();
    }

    @Bean
    MessagePostProcessor gZipPostProcessor() {
        GZipPostProcessor gZipPostProcessor = new GZipPostProcessor();
        gZipPostProcessor.setLevel(this.rabbitBinderConfigurationProperties.getCompressionLevel());
        return gZipPostProcessor;
    }

    @Bean
    RabbitExchangeQueueProvisioner provisioningProvider(List<DeclarableCustomizer> declarableCustomizers) {
        return new RabbitExchangeQueueProvisioner(this.rabbitConnectionFactory, declarableCustomizers);
    }
}

