/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.pulsar.config;

import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.pulsar.autoconfigure.PulsarProperties;
import org.springframework.cloud.stream.binder.Binder;
import org.springframework.cloud.stream.binder.pulsar.PulsarMessageChannelBinder;
import org.springframework.cloud.stream.binder.pulsar.properties.PulsarBinderConfigurationProperties;
import org.springframework.cloud.stream.binder.pulsar.properties.PulsarExtendedBindingProperties;
import org.springframework.cloud.stream.binder.pulsar.provisioning.PulsarTopicProvisioner;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.pulsar.core.PulsarAdministration;
import org.springframework.pulsar.core.PulsarConsumerFactory;
import org.springframework.pulsar.core.PulsarTemplate;
import org.springframework.pulsar.core.PulsarTopicBuilder;
import org.springframework.pulsar.core.SchemaResolver;
import org.springframework.pulsar.support.header.JacksonUtils;
import org.springframework.pulsar.support.header.JsonPulsarHeaderMapper;
import org.springframework.pulsar.support.header.PulsarHeaderMapper;
import org.springframework.pulsar.support.header.ToStringPulsarHeaderMapper;

@Configuration(proxyBeanMethods=false)
@ConditionalOnMissingBean(value={Binder.class})
@EnableConfigurationProperties(value={PulsarProperties.class, PulsarExtendedBindingProperties.class, PulsarBinderConfigurationProperties.class})
public class PulsarBinderConfiguration {
    @Bean
    public PulsarTopicProvisioner pulsarTopicProvisioner(PulsarAdministration pulsarAdministration, PulsarBinderConfigurationProperties pulsarBinderConfigurationProperties, PulsarTopicBuilder topicBuilder) {
        return new PulsarTopicProvisioner(pulsarAdministration, pulsarBinderConfigurationProperties, topicBuilder);
    }

    @Bean
    @ConditionalOnMissingBean
    public PulsarHeaderMapper pulsarHeaderMapper() {
        if (JacksonUtils.isJacksonPresent()) {
            return JsonPulsarHeaderMapper.builder().build();
        }
        return new ToStringPulsarHeaderMapper();
    }

    @Bean
    public PulsarMessageChannelBinder pulsarMessageChannelBinder(PulsarTopicProvisioner pulsarTopicProvisioner, PulsarTemplate<Object> pulsarTemplate, PulsarConsumerFactory<?> pulsarConsumerFactory, PulsarBinderConfigurationProperties binderConfigProps, PulsarExtendedBindingProperties bindingConfigProps, SchemaResolver schemaResolver, PulsarHeaderMapper headerMapper) {
        PulsarMessageChannelBinder pulsarMessageChannelBinder = new PulsarMessageChannelBinder(pulsarTopicProvisioner, pulsarTemplate, pulsarConsumerFactory, binderConfigProps, schemaResolver, headerMapper);
        pulsarMessageChannelBinder.setExtendedBindingProperties(bindingConfigProps);
        return pulsarMessageChannelBinder;
    }
}

