/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.pulsar.properties;

import java.time.Duration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.pulsar.client.api.ProducerCryptoFailureAction;
import org.springframework.boot.autoconfigure.pulsar.PulsarProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.lang.Nullable;
import org.springframework.util.unit.DataSize;

public class ProducerConfigProperties
extends PulsarProperties.Producer {
    private Boolean blockIfQueueFull = false;
    private Integer maxPendingMessages = 1000;
    private Integer maxPendingMessagesAcrossPartitions = 50000;
    private ProducerCryptoFailureAction cryptoFailureAction = ProducerCryptoFailureAction.FAIL;
    private Set<String> encryptionKeys = new HashSet<String>();
    @Nullable
    private Long initialSequenceId;
    private Boolean autoUpdatePartitions = true;
    private Duration autoUpdatePartitionsInterval = Duration.ofMinutes(1L);
    private Boolean multiSchema = true;
    private Boolean lazyStartPartitionedProducers = false;
    private final Batching batch = new Batching();
    private Map<String, String> properties = new HashMap<String, String>();

    public Batching getBatch() {
        return this.batch;
    }

    public Boolean getBlockIfQueueFull() {
        return this.blockIfQueueFull;
    }

    public void setBlockIfQueueFull(Boolean blockIfQueueFull) {
        this.blockIfQueueFull = blockIfQueueFull;
    }

    public Integer getMaxPendingMessages() {
        return this.maxPendingMessages;
    }

    public void setMaxPendingMessages(Integer maxPendingMessages) {
        this.maxPendingMessages = maxPendingMessages;
    }

    public Integer getMaxPendingMessagesAcrossPartitions() {
        return this.maxPendingMessagesAcrossPartitions;
    }

    public void setMaxPendingMessagesAcrossPartitions(Integer maxPendingMessagesAcrossPartitions) {
        this.maxPendingMessagesAcrossPartitions = maxPendingMessagesAcrossPartitions;
    }

    public ProducerCryptoFailureAction getCryptoFailureAction() {
        return this.cryptoFailureAction;
    }

    public void setCryptoFailureAction(ProducerCryptoFailureAction cryptoFailureAction) {
        this.cryptoFailureAction = cryptoFailureAction;
    }

    public Set<String> getEncryptionKeys() {
        return this.encryptionKeys;
    }

    public void setEncryptionKeys(Set<String> encryptionKeys) {
        this.encryptionKeys = encryptionKeys;
    }

    @Nullable
    public Long getInitialSequenceId() {
        return this.initialSequenceId;
    }

    public void setInitialSequenceId(@Nullable Long initialSequenceId) {
        this.initialSequenceId = initialSequenceId;
    }

    public Boolean getAutoUpdatePartitions() {
        return this.autoUpdatePartitions;
    }

    public void setAutoUpdatePartitions(Boolean autoUpdatePartitions) {
        this.autoUpdatePartitions = autoUpdatePartitions;
    }

    public Duration getAutoUpdatePartitionsInterval() {
        return this.autoUpdatePartitionsInterval;
    }

    public void setAutoUpdatePartitionsInterval(Duration autoUpdatePartitionsInterval) {
        this.autoUpdatePartitionsInterval = autoUpdatePartitionsInterval;
    }

    public Boolean getMultiSchema() {
        return this.multiSchema;
    }

    public void setMultiSchema(Boolean multiSchema) {
        this.multiSchema = multiSchema;
    }

    public Boolean getLazyStartPartitionedProducers() {
        return this.lazyStartPartitionedProducers;
    }

    public void setLazyStartPartitionedProducers(Boolean lazyStartPartitionedProducers) {
        this.lazyStartPartitionedProducers = lazyStartPartitionedProducers;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public Map<String, Object> toBaseProducerPropertiesMap() {
        Properties producerProps = new Properties();
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from(() -> ((ProducerConfigProperties)this).getAccessMode()).to(producerProps.in("accessMode"));
        map.from(() -> ((ProducerConfigProperties)this).isBatchingEnabled()).to(producerProps.in("batchingEnabled"));
        map.from(() -> ((ProducerConfigProperties)this).isChunkingEnabled()).to(producerProps.in("chunkingEnabled"));
        map.from(() -> ((ProducerConfigProperties)this).getCompressionType()).to(producerProps.in("compressionType"));
        map.from(() -> ((ProducerConfigProperties)this).getHashingScheme()).to(producerProps.in("hashingScheme"));
        map.from(() -> ((ProducerConfigProperties)this).getMessageRoutingMode()).to(producerProps.in("messageRoutingMode"));
        map.from(() -> ((ProducerConfigProperties)this).getName()).to(producerProps.in("producerName"));
        map.from(() -> ((ProducerConfigProperties)this).getSendTimeout()).asInt(Duration::toMillis).to(producerProps.in("sendTimeoutMs"));
        map.from(() -> ((ProducerConfigProperties)this).getTopicName()).to(producerProps.in("topicName"));
        return producerProps;
    }

    public Map<String, Object> toExtendedProducerPropertiesMap() {
        Properties producerProps = new Properties();
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from(this::getAutoUpdatePartitions).to(producerProps.in("autoUpdatePartitions"));
        map.from(this::getAutoUpdatePartitionsInterval).as(Duration::toSeconds).to(producerProps.in("autoUpdatePartitionsIntervalSeconds"));
        map.from(this::getBlockIfQueueFull).to(producerProps.in("blockIfQueueFull"));
        map.from(this::getCryptoFailureAction).to(producerProps.in("cryptoFailureAction"));
        map.from(this::getEncryptionKeys).to(producerProps.in("encryptionKeys"));
        map.from(this::getInitialSequenceId).to(producerProps.in("initialSequenceId"));
        map.from(this::getLazyStartPartitionedProducers).to(producerProps.in("lazyStartPartitionedProducers"));
        map.from(this::getMaxPendingMessages).to(producerProps.in("maxPendingMessages"));
        map.from(this::getMaxPendingMessagesAcrossPartitions).to(producerProps.in("maxPendingMessagesAcrossPartitions"));
        map.from(this::getMultiSchema).to(producerProps.in("multiSchema"));
        map.from(this::getProperties).to(producerProps.in("properties"));
        if (this.isBatchingEnabled()) {
            map.from(this::getBatch).as(Batching::getMaxPublishDelay).as(it -> it.toNanos() / 1000L).to(producerProps.in("batchingMaxPublishDelayMicros"));
            map.from(this::getBatch).as(Batching::getPartitionSwitchFrequencyByPublishDelay).to(producerProps.in("batchingPartitionSwitchFrequencyByPublishDelay"));
            map.from(this::getBatch).as(Batching::getMaxMessages).to(producerProps.in("batchingMaxMessages"));
            map.from(this::getBatch).as(Batching::getMaxBytes).asInt(DataSize::toBytes).to(producerProps.in("batchingMaxBytes"));
        }
        return producerProps;
    }

    public Map<String, Object> toAllProducerPropertiesMap() {
        Map<String, Object> producerProps = this.toBaseProducerPropertiesMap();
        producerProps.putAll(this.toExtendedProducerPropertiesMap());
        return producerProps;
    }

    public static class Batching {
        private Duration maxPublishDelay = Duration.ofMillis(1L);
        private Integer partitionSwitchFrequencyByPublishDelay = 10;
        private Integer maxMessages = 1000;
        private DataSize maxBytes = DataSize.ofKilobytes((long)128L);
        private Boolean enabled = true;

        public Duration getMaxPublishDelay() {
            return this.maxPublishDelay;
        }

        public void setMaxPublishDelay(Duration maxPublishDelay) {
            this.maxPublishDelay = maxPublishDelay;
        }

        public Integer getPartitionSwitchFrequencyByPublishDelay() {
            return this.partitionSwitchFrequencyByPublishDelay;
        }

        public void setPartitionSwitchFrequencyByPublishDelay(Integer partitionSwitchFrequencyByPublishDelay) {
            this.partitionSwitchFrequencyByPublishDelay = partitionSwitchFrequencyByPublishDelay;
        }

        public Integer getMaxMessages() {
            return this.maxMessages;
        }

        public void setMaxMessages(Integer maxMessages) {
            this.maxMessages = maxMessages;
        }

        public DataSize getMaxBytes() {
            return this.maxBytes;
        }

        public void setMaxBytes(DataSize maxBytes) {
            this.maxBytes = maxBytes;
        }

        public Boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }
    }

    static class Properties
    extends HashMap<String, Object> {
        Properties() {
        }

        <V> Consumer<V> in(String key) {
            return value -> this.put(key, value);
        }
    }
}

