/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka.config;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.io.IOException;
import java.util.stream.Collectors;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.kafka.KafkaConnectionDetails;
import org.springframework.boot.autoconfigure.kafka.KafkaProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.binder.Binder;
import org.springframework.cloud.stream.binder.kafka.KafkaBinderMetrics;
import org.springframework.cloud.stream.binder.kafka.KafkaBindingRebalanceListener;
import org.springframework.cloud.stream.binder.kafka.KafkaMessageChannelBinder;
import org.springframework.cloud.stream.binder.kafka.KafkaNullConverter;
import org.springframework.cloud.stream.binder.kafka.config.ClientFactoryCustomizer;
import org.springframework.cloud.stream.binder.kafka.config.KafkaBinderHealthIndicatorConfiguration;
import org.springframework.cloud.stream.binder.kafka.properties.JaasLoginModuleConfiguration;
import org.springframework.cloud.stream.binder.kafka.properties.KafkaBinderConfigurationProperties;
import org.springframework.cloud.stream.binder.kafka.properties.KafkaExtendedBindingProperties;
import org.springframework.cloud.stream.binder.kafka.provisioning.AdminClientConfigCustomizer;
import org.springframework.cloud.stream.binder.kafka.provisioning.KafkaTopicProvisioner;
import org.springframework.cloud.stream.binder.kafka.support.ConsumerConfigCustomizer;
import org.springframework.cloud.stream.binder.kafka.support.ProducerConfigCustomizer;
import org.springframework.cloud.stream.binder.kafka.utils.DlqDestinationResolver;
import org.springframework.cloud.stream.binder.kafka.utils.DlqPartitionFunction;
import org.springframework.cloud.stream.config.ConsumerEndpointCustomizer;
import org.springframework.cloud.stream.config.ListenerContainerCustomizer;
import org.springframework.cloud.stream.config.MessageSourceCustomizer;
import org.springframework.cloud.stream.config.ProducerMessageHandlerCustomizer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.integration.kafka.inbound.KafkaMessageDrivenChannelAdapter;
import org.springframework.integration.kafka.inbound.KafkaMessageSource;
import org.springframework.integration.kafka.outbound.KafkaProducerMessageHandler;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaProducerFactory;
import org.springframework.kafka.core.MicrometerConsumerListener;
import org.springframework.kafka.core.MicrometerProducerListener;
import org.springframework.kafka.core.ProducerFactory;
import org.springframework.kafka.listener.AbstractMessageListenerContainer;
import org.springframework.kafka.security.jaas.KafkaJaasLoginModuleInitializer;
import org.springframework.kafka.support.LoggingProducerListener;
import org.springframework.kafka.support.ProducerListener;
import org.springframework.lang.Nullable;
import org.springframework.messaging.converter.MessageConverter;

@Configuration(proxyBeanMethods=false)
@ConditionalOnMissingBean(value={Binder.class})
@Import(value={KafkaBinderHealthIndicatorConfiguration.class})
@EnableConfigurationProperties(value={KafkaProperties.class, KafkaExtendedBindingProperties.class})
public class KafkaBinderConfiguration {
    @Bean
    @ConfigurationProperties(prefix="spring.cloud.stream.kafka.binder")
    KafkaBinderConfigurationProperties configurationProperties(KafkaProperties kafkaProperties, ObjectProvider<KafkaConnectionDetails> kafkaConnectionDetails) {
        return new KafkaBinderConfigurationProperties(kafkaProperties, kafkaConnectionDetails);
    }

    @Bean
    KafkaTopicProvisioner provisioningProvider(KafkaBinderConfigurationProperties configurationProperties, ObjectProvider<AdminClientConfigCustomizer> adminClientConfigCustomizers, KafkaProperties kafkaProperties, ObjectProvider<KafkaConnectionDetails> kafkaConnectionDetails) {
        return new KafkaTopicProvisioner(configurationProperties, kafkaProperties, (KafkaConnectionDetails)kafkaConnectionDetails.getIfAvailable(), adminClientConfigCustomizers.orderedStream().collect(Collectors.toList()));
    }

    @Bean
    KafkaMessageChannelBinder kafkaMessageChannelBinder(KafkaBinderConfigurationProperties configurationProperties, KafkaTopicProvisioner provisioningProvider, @Nullable ListenerContainerCustomizer<AbstractMessageListenerContainer<?, ?>> listenerContainerCustomizer, @Nullable MessageSourceCustomizer<KafkaMessageSource<?, ?>> sourceCustomizer, @Nullable ProducerMessageHandlerCustomizer<KafkaProducerMessageHandler<?, ?>> messageHandlerCustomizer, @Nullable ConsumerEndpointCustomizer<KafkaMessageDrivenChannelAdapter<?, ?>> consumerCustomizer, ObjectProvider<KafkaBindingRebalanceListener> rebalanceListener, ObjectProvider<DlqPartitionFunction> dlqPartitionFunction, ObjectProvider<DlqDestinationResolver> dlqDestinationResolver, ObjectProvider<ClientFactoryCustomizer> clientFactoryCustomizers, ObjectProvider<ConsumerConfigCustomizer> consumerConfigCustomizers, ObjectProvider<ProducerConfigCustomizer> producerConfigCustomizers, ProducerListener producerListener, KafkaExtendedBindingProperties kafkaExtendedBindingProperties) {
        KafkaMessageChannelBinder kafkaMessageChannelBinder = new KafkaMessageChannelBinder(configurationProperties, provisioningProvider, listenerContainerCustomizer, sourceCustomizer, (KafkaBindingRebalanceListener)rebalanceListener.getIfUnique(), (DlqPartitionFunction)dlqPartitionFunction.getIfUnique(), (DlqDestinationResolver)dlqDestinationResolver.getIfUnique());
        kafkaMessageChannelBinder.setProducerListener((ProducerListener<byte[], byte[]>)producerListener);
        kafkaMessageChannelBinder.setExtendedBindingProperties(kafkaExtendedBindingProperties);
        kafkaMessageChannelBinder.setProducerMessageHandlerCustomizer(messageHandlerCustomizer);
        kafkaMessageChannelBinder.setConsumerEndpointCustomizer(consumerCustomizer);
        clientFactoryCustomizers.orderedStream().forEach(kafkaMessageChannelBinder::addClientFactoryCustomizer);
        consumerConfigCustomizers.orderedStream().forEach(kafkaMessageChannelBinder::addConsumerConfigCustomizer);
        producerConfigCustomizers.orderedStream().forEach(kafkaMessageChannelBinder::addProducerConfigCustomizer);
        return kafkaMessageChannelBinder;
    }

    @Bean
    @ConditionalOnMissingBean(value={ProducerListener.class})
    ProducerListener producerListener() {
        return new LoggingProducerListener();
    }

    @Bean
    @ConditionalOnMissingBean(value={KafkaNullConverter.class})
    MessageConverter kafkaNullConverter() {
        return new KafkaNullConverter();
    }

    @Bean
    @ConditionalOnMissingBean(value={KafkaJaasLoginModuleInitializer.class})
    public KafkaJaasLoginModuleInitializer jaasInitializer(KafkaBinderConfigurationProperties configurationProperties) throws IOException {
        JaasLoginModuleConfiguration jaas = configurationProperties.getJaas();
        if (jaas == null) {
            return null;
        }
        KafkaJaasLoginModuleInitializer kafkaJaasLoginModuleInitializer = new KafkaJaasLoginModuleInitializer();
        kafkaJaasLoginModuleInitializer.setLoginModule(jaas.getLoginModule());
        KafkaJaasLoginModuleInitializer.ControlFlag controlFlag = jaas.getControlFlag();
        if (controlFlag != null) {
            kafkaJaasLoginModuleInitializer.setControlFlag(controlFlag);
        }
        kafkaJaasLoginModuleInitializer.setOptions(jaas.getOptions());
        return kafkaJaasLoginModuleInitializer;
    }

    public static class JaasConfigurationProperties {
        private JaasLoginModuleConfiguration kafka;
        private JaasLoginModuleConfiguration zookeeper;
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(name={"outerContext"})
    @ConditionalOnMissingBean(value={KafkaBinderMetrics.class})
    @ConditionalOnClass(name={"io.micrometer.core.instrument.MeterRegistry"})
    protected class KafkaBinderMetricsConfigurationWithMultiBinder {
        protected KafkaBinderMetricsConfigurationWithMultiBinder() {
        }

        @Bean
        public MeterBinder kafkaBinderMetrics(KafkaMessageChannelBinder kafkaMessageChannelBinder, KafkaBinderConfigurationProperties configurationProperties, ConfigurableApplicationContext context) {
            MeterRegistry meterRegistry = (MeterRegistry)((ApplicationContext)context.getBean("outerContext", ApplicationContext.class)).getBean(MeterRegistry.class);
            return new KafkaBinderMetrics(kafkaMessageChannelBinder, configurationProperties, null, meterRegistry);
        }

        @ConditionalOnClass(name={"org.springframework.kafka.core.MicrometerConsumerListener"})
        protected class KafkaMicrometer {
            protected KafkaMicrometer() {
            }

            @Bean
            @ConditionalOnMissingBean(name={"binderClientFactoryCustomizer"})
            public ClientFactoryCustomizer binderClientFactoryCustomizer(final ConfigurableApplicationContext context) {
                return new ClientFactoryCustomizer(){
                    MeterRegistry meterRegistry;
                    {
                        this.meterRegistry = (MeterRegistry)((ApplicationContext)context.getBean("outerContext", ApplicationContext.class)).getBean(MeterRegistry.class);
                    }

                    @Override
                    public void configure(ProducerFactory<?, ?> pf) {
                        if (pf instanceof DefaultKafkaProducerFactory) {
                            pf.addListener((ProducerFactory.Listener)new MicrometerProducerListener(this.meterRegistry));
                        }
                    }

                    @Override
                    public void configure(ConsumerFactory<?, ?> cf) {
                        if (cf instanceof DefaultKafkaConsumerFactory) {
                            cf.addListener((ConsumerFactory.Listener)new MicrometerConsumerListener(this.meterRegistry));
                        }
                    }
                };
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(value={KafkaBinderMetrics.class}, name={"outerContext"})
    @ConditionalOnClass(name={"io.micrometer.core.instrument.MeterRegistry"})
    protected class KafkaBinderMetricsConfiguration {
        protected KafkaBinderMetricsConfiguration() {
        }

        @Bean
        @ConditionalOnBean(value={MeterRegistry.class})
        @ConditionalOnMissingBean(value={KafkaBinderMetrics.class})
        public MeterBinder kafkaBinderMetrics(KafkaMessageChannelBinder kafkaMessageChannelBinder, KafkaBinderConfigurationProperties configurationProperties, MeterRegistry meterRegistry) {
            return new KafkaBinderMetrics(kafkaMessageChannelBinder, configurationProperties, null, meterRegistry);
        }

        @ConditionalOnClass(name={"org.springframework.kafka.core.MicrometerConsumerListener"})
        @ConditionalOnBean(value={MeterRegistry.class})
        protected class KafkaMicrometer {
            protected KafkaMicrometer() {
            }

            @Bean
            @ConditionalOnMissingBean(name={"binderClientFactoryCustomizer"})
            public ClientFactoryCustomizer binderClientFactoryCustomizer(final MeterRegistry meterRegistry) {
                return new ClientFactoryCustomizer(){

                    @Override
                    public void configure(ProducerFactory<?, ?> pf) {
                        if (pf instanceof DefaultKafkaProducerFactory) {
                            pf.addListener((ProducerFactory.Listener)new MicrometerProducerListener(meterRegistry));
                        }
                    }

                    @Override
                    public void configure(ConsumerFactory<?, ?> cf) {
                        if (cf instanceof DefaultKafkaConsumerFactory) {
                            cf.addListener((ConsumerFactory.Listener)new MicrometerConsumerListener(meterRegistry));
                        }
                    }
                };
            }
        }
    }
}

