/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka;

import java.util.Collections;
import org.springframework.kafka.support.KafkaNull;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.AbstractMessageConverter;
import org.springframework.util.MimeTypeUtils;

public class KafkaNullConverter
extends AbstractMessageConverter {
    public KafkaNullConverter() {
        super(Collections.singletonList(MimeTypeUtils.ALL));
    }

    protected boolean supportsMimeType(MessageHeaders headers) {
        return true;
    }

    protected boolean supports(Class<?> aClass) {
        return KafkaNull.class.equals(aClass);
    }

    protected boolean canConvertFrom(Message<?> message, Class<?> targetClass) {
        return message.getPayload() instanceof KafkaNull;
    }

    protected Object convertFromInternal(Message<?> message, Class<?> targetClass, Object conversionHint) {
        return message.getPayload();
    }

    protected Object convertToInternal(Object payload, MessageHeaders headers, Object conversionHint) {
        return payload;
    }
}

