/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka.streams;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.StringJoiner;
import org.apache.kafka.streams.KafkaStreams;
import org.springframework.core.log.LogAccessor;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;

class KafkaStreamsVersionAgnosticTopologyInfoFacade {
    private final LogAccessor logger = new LogAccessor(KafkaStreamsVersionAgnosticTopologyInfoFacade.class);
    @Nullable
    private Field topologyInfoField;
    @Nullable
    private Method sourceTopicsForStoreMethod;
    private boolean sourceTopicsForStoreMethodHasTwoArgs;

    KafkaStreamsVersionAgnosticTopologyInfoFacade() {
        this(KafkaStreams.class);
    }

    KafkaStreamsVersionAgnosticTopologyInfoFacade(Class<?> rootClass) {
        Field topologyMetadataField;
        Field internalTopologyBuilderField = ReflectionUtils.findField(rootClass, (String)"internalTopologyBuilder");
        if (internalTopologyBuilderField != null) {
            internalTopologyBuilderField.setAccessible(true);
            this.topologyInfoField = internalTopologyBuilderField;
            this.sourceTopicsForStoreMethod = ReflectionUtils.findMethod(internalTopologyBuilderField.getType(), (String)"sourceTopicsForStore", (Class[])new Class[]{String.class});
        }
        if (this.sourceTopicsForStoreMethod == null && (topologyMetadataField = ReflectionUtils.findField(rootClass, (String)"topologyMetadata")) != null) {
            topologyMetadataField.setAccessible(true);
            this.topologyInfoField = topologyMetadataField;
            this.sourceTopicsForStoreMethod = ReflectionUtils.findMethod(topologyMetadataField.getType(), (String)"sourceTopicsForStore", (Class[])new Class[]{String.class});
            if (this.sourceTopicsForStoreMethod == null) {
                this.sourceTopicsForStoreMethod = ReflectionUtils.findMethod(topologyMetadataField.getType(), (String)"sourceTopicsForStore", (Class[])new Class[]{String.class, String.class});
                this.sourceTopicsForStoreMethodHasTwoArgs = true;
            }
        }
        if (this.sourceTopicsForStoreMethod != null) {
            this.sourceTopicsForStoreMethod.setAccessible(true);
            this.logger.info(() -> "Using " + this.methodDescription(this.sourceTopicsForStoreMethod));
        } else {
            this.logger.warn((CharSequence)"Could not find 'topologyMetadata.sourceTopicsForStore' or 'internalTopologyBuilder.sourceTopicsForStore' from KafkaStreams class - will be unable to reason about state stores.");
        }
    }

    boolean streamsAppActuallyHasStore(KafkaStreams kafkaStreams, String storeName) {
        if (this.sourceTopicsForStoreMethod == null) {
            this.logger.warn((CharSequence)"Unable to reason about state store because sourceTopicsForStore method was not found - returning false");
            return false;
        }
        try {
            Object[] objectArray;
            Object topologyInfo = ReflectionUtils.getField((Field)this.topologyInfoField, (Object)kafkaStreams);
            if (topologyInfo == null) {
                this.logger.warn((CharSequence)"Unable to reason about state store because topologyInfo field was null - returning false");
                return false;
            }
            if (this.sourceTopicsForStoreMethodHasTwoArgs) {
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = storeName;
                objectArray = objectArray2;
                objectArray2[1] = null;
            } else {
                Object[] objectArray3 = new Object[1];
                objectArray = objectArray3;
                objectArray3[0] = storeName;
            }
            Object[] args = objectArray;
            Collection sourceTopicsForStore = (Collection)ReflectionUtils.invokeMethod((Method)this.sourceTopicsForStoreMethod, (Object)topologyInfo, (Object[])args);
            return !CollectionUtils.isEmpty((Collection)sourceTopicsForStore);
        }
        catch (Exception ex) {
            this.logger.error((Throwable)ex, () -> "Unable to reason about state store due to error: " + ex.getMessage() + " - returning false");
            return false;
        }
    }

    private String methodDescription(Method method) {
        StringJoiner sj = new StringJoiner(",", method.getName() + "(", ")");
        for (Class<?> parameterType : method.getParameterTypes()) {
            sj.add(parameterType.getTypeName());
        }
        return "method " + method.getDeclaringClass().getTypeName() + "." + sj.toString();
    }
}

