/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka.streams;

import java.io.IOException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.stream.binder.kafka.properties.JaasLoginModuleConfiguration;
import org.springframework.cloud.stream.binder.kafka.properties.KafkaBinderConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.security.jaas.KafkaJaasLoginModuleInitializer;

@Configuration
public class KafkaStreamsJaasConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={KafkaJaasLoginModuleInitializer.class})
    public KafkaJaasLoginModuleInitializer jaasInitializer(KafkaBinderConfigurationProperties configurationProperties) throws IOException {
        KafkaJaasLoginModuleInitializer kafkaJaasLoginModuleInitializer = new KafkaJaasLoginModuleInitializer();
        JaasLoginModuleConfiguration jaas = configurationProperties.getJaas();
        if (jaas != null) {
            kafkaJaasLoginModuleInitializer.setLoginModule(jaas.getLoginModule());
            KafkaJaasLoginModuleInitializer.ControlFlag controlFlag = jaas.getControlFlag();
            if (controlFlag != null) {
                kafkaJaasLoginModuleInitializer.setControlFlag(controlFlag);
            }
            kafkaJaasLoginModuleInitializer.setOptions(jaas.getOptions());
        }
        return kafkaJaasLoginModuleInitializer;
    }
}

