/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka.streams.function;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.kafka.streams.kstream.GlobalKTable;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.KTable;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.cloud.stream.binding.AbstractBindableProxyFactory;
import org.springframework.cloud.stream.binding.BoundTargetHolder;
import org.springframework.cloud.stream.function.StreamFunctionProperties;
import org.springframework.core.ResolvableType;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class KafkaStreamsBindableProxyFactory
extends AbstractBindableProxyFactory
implements InitializingBean,
BeanFactoryAware {
    @Autowired
    private StreamFunctionProperties streamFunctionProperties;
    private final ResolvableType type;
    private final Method method;
    private final String functionName;
    private BeanFactory beanFactory;

    public KafkaStreamsBindableProxyFactory(ResolvableType type, String functionName, Method method) {
        super(type.getType().getClass());
        this.type = type;
        this.functionName = functionName;
        this.method = method;
    }

    public void afterPropertiesSet() {
        Object bean;
        Assert.notEmpty((Map)this.bindingTargetFactories, (String)"'bindingTargetFactories' cannot be empty");
        int resolvableTypeDepthCounter = 0;
        boolean isKafkaStreamsType = this.type.getRawClass().isAssignableFrom(KStream.class) || this.type.getRawClass().isAssignableFrom(KTable.class) || this.type.getRawClass().isAssignableFrom(GlobalKTable.class);
        ResolvableType argument = isKafkaStreamsType ? this.type : this.type.getGeneric(new int[]{resolvableTypeDepthCounter++});
        List<String> inputBindings = this.buildInputBindings();
        Iterator<String> iterator = inputBindings.iterator();
        String next = iterator.next();
        this.bindInput(argument, next);
        if (this.method != null && (BiFunction.class.isAssignableFrom((bean = this.beanFactory.getBean(this.functionName)).getClass()) || BiConsumer.class.isAssignableFrom(bean.getClass()))) {
            argument = ResolvableType.forMethodParameter((Method)this.method, (int)1);
            next = iterator.next();
            this.bindInput(argument, next);
        }
        if (this.type.getRawClass() != null && (this.type.getRawClass().isAssignableFrom(BiFunction.class) || this.type.getRawClass().isAssignableFrom(BiConsumer.class))) {
            argument = this.type.getGeneric(new int[]{resolvableTypeDepthCounter++});
            next = iterator.next();
            this.bindInput(argument, next);
        }
        ResolvableType outboundArgument = this.type.getGeneric(new int[]{resolvableTypeDepthCounter});
        if (this.method != null) {
            outboundArgument = ResolvableType.forMethodReturnType((Method)this.method);
        }
        while (this.isAnotherFunctionOrConsumerFound(outboundArgument)) {
            argument = outboundArgument.getGeneric(new int[]{0});
            String next1 = iterator.next();
            this.bindInput(argument, next1);
            outboundArgument = outboundArgument.getGeneric(new int[]{1});
        }
        if (outboundArgument.getRawClass() != null && !outboundArgument.isArray() && outboundArgument.getRawClass().isAssignableFrom(KStream.class)) {
            List outputBindings = this.streamFunctionProperties.getOutputBindings(this.functionName);
            String outputBinding = null;
            if (!CollectionUtils.isEmpty((Collection)outputBindings)) {
                Iterator outputBindingsIter = outputBindings.iterator();
                if (outputBindingsIter.hasNext()) {
                    outputBinding = (String)outputBindingsIter.next();
                }
            } else {
                outputBinding = String.format("%s-%s-0", this.functionName, "out");
            }
            Assert.isTrue((outputBinding != null ? 1 : 0) != 0, (String)"output binding is not inferred.");
            this.outputHolders.put(outputBinding, new BoundTargetHolder(this.getBindingTargetFactory(KStream.class).createOutput(outputBinding), true));
            String outputBinding1 = outputBinding;
            RootBeanDefinition rootBeanDefinition1 = new RootBeanDefinition();
            rootBeanDefinition1.setInstanceSupplier(() -> ((BoundTargetHolder)this.outputHolders.get(outputBinding1)).getBoundTarget());
            BeanDefinitionRegistry registry = (BeanDefinitionRegistry)this.beanFactory;
            registry.registerBeanDefinition(outputBinding1, (BeanDefinition)rootBeanDefinition1);
        }
    }

    private boolean isAnotherFunctionOrConsumerFound(ResolvableType arg1) {
        return arg1 != null && !arg1.isArray() && arg1.getRawClass() != null && (arg1.getRawClass().isAssignableFrom(Function.class) || arg1.getRawClass().isAssignableFrom(Consumer.class));
    }

    private List<String> buildInputBindings() {
        int numberOfInputs;
        ArrayList<String> inputs = new ArrayList<String>();
        List inputBindings = this.streamFunctionProperties.getInputBindings(this.functionName);
        if (!CollectionUtils.isEmpty((Collection)inputBindings)) {
            inputs.addAll(inputBindings);
            return inputs;
        }
        int n = numberOfInputs = this.type.getRawClass() != null && (this.type.getRawClass().isAssignableFrom(BiFunction.class) || this.type.getRawClass().isAssignableFrom(BiConsumer.class)) ? 2 : this.getNumberOfInputs();
        if (this.method != null) {
            Object bean;
            ResolvableType returnType = ResolvableType.forMethodReturnType((Method)this.method);
            Object object = bean = this.beanFactory.containsBean(this.functionName) ? this.beanFactory.getBean(this.functionName) : null;
            if (bean != null && (BiFunction.class.isAssignableFrom(bean.getClass()) || BiConsumer.class.isAssignableFrom(bean.getClass()))) {
                numberOfInputs = 2;
            } else if (returnType.getRawClass().isAssignableFrom(Function.class) || returnType.getRawClass().isAssignableFrom(Consumer.class)) {
                numberOfInputs = 1;
                ResolvableType arg1 = returnType;
                while (this.isAnotherFunctionOrConsumerFound(arg1)) {
                    arg1 = arg1.getGeneric(new int[]{1});
                    ++numberOfInputs;
                }
            }
        }
        int i = 0;
        while (i < numberOfInputs) {
            inputs.add(String.format("%s-%s-%d", this.functionName, "in", i++));
        }
        return inputs;
    }

    private int getNumberOfInputs() {
        int numberOfInputs = 1;
        ResolvableType arg1 = this.type.getGeneric(new int[]{1});
        while (this.isAnotherFunctionOrConsumerFound(arg1)) {
            arg1 = arg1.getGeneric(new int[]{1});
            ++numberOfInputs;
        }
        return numberOfInputs;
    }

    private void bindInput(ResolvableType arg0, String inputName) {
        if (arg0.getRawClass() != null) {
            this.inputHolders.put(inputName, new BoundTargetHolder(this.getBindingTargetFactory(arg0.getRawClass()).createInput(inputName), true));
        }
        BeanDefinitionRegistry registry = (BeanDefinitionRegistry)this.beanFactory;
        RootBeanDefinition rootBeanDefinition = new RootBeanDefinition();
        rootBeanDefinition.setInstanceSupplier(() -> ((BoundTargetHolder)this.inputHolders.get(inputName)).getBoundTarget());
        registry.registerBeanDefinition(inputName, (BeanDefinition)rootBeanDefinition);
    }

    public Set<String> getInputs() {
        LinkedHashSet<String> ins = new LinkedHashSet<String>();
        this.inputHolders.forEach((s, BoundTargetHolder2) -> ins.add((String)s));
        return ins;
    }

    public Set<String> getOutputs() {
        LinkedHashSet<String> outs = new LinkedHashSet<String>();
        this.outputHolders.forEach((s, BoundTargetHolder2) -> outs.add((String)s));
        return outs;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void addOutputBinding(String output, Class<?> clazz) {
        this.outputHolders.put(output, new BoundTargetHolder(this.getBindingTargetFactory(clazz).createOutput(output), true));
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public Map<String, BoundTargetHolder> getOutputHolders() {
        return this.outputHolders;
    }
}

