/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka.streams.endpoint;

import java.util.List;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.cloud.stream.binder.kafka.streams.KafkaStreamsRegistry;
import org.springframework.kafka.config.StreamsBuilderFactoryBean;
import org.springframework.util.StringUtils;

@Endpoint(id="topology")
public class TopologyEndpoint {
    public static final String NO_TOPOLOGY_FOUND_MSG = "No topology found for the given application ID";
    private final KafkaStreamsRegistry kafkaStreamsRegistry;

    public TopologyEndpoint(KafkaStreamsRegistry kafkaStreamsRegistry) {
        this.kafkaStreamsRegistry = kafkaStreamsRegistry;
    }

    @ReadOperation
    public String topology() {
        List<StreamsBuilderFactoryBean> streamsBuilderFactoryBeans = this.kafkaStreamsRegistry.streamsBuilderFactoryBeans();
        StringBuilder topologyDescription = new StringBuilder();
        streamsBuilderFactoryBeans.stream().forEach(streamsBuilderFactoryBean -> topologyDescription.append(streamsBuilderFactoryBean.getTopology().describe().toString()));
        return topologyDescription.toString();
    }

    @ReadOperation
    public String topology(@Selector String applicationId) {
        if (!StringUtils.isEmpty((Object)applicationId)) {
            StreamsBuilderFactoryBean streamsBuilderFactoryBean = this.kafkaStreamsRegistry.streamsBuilderFactoryBean(applicationId);
            if (streamsBuilderFactoryBean != null) {
                return streamsBuilderFactoryBean.getTopology().describe().toString();
            }
            return NO_TOPOLOGY_FOUND_MSG;
        }
        return NO_TOPOLOGY_FOUND_MSG;
    }
}

