/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka.streams;

import java.util.Map;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.kafka.KafkaAutoConfiguration;
import org.springframework.boot.autoconfigure.kafka.KafkaProperties;
import org.springframework.cloud.stream.binder.kafka.properties.KafkaBinderConfigurationProperties;
import org.springframework.cloud.stream.binder.kafka.provisioning.AdminClientConfigCustomizer;
import org.springframework.cloud.stream.binder.kafka.provisioning.KafkaTopicProvisioner;
import org.springframework.cloud.stream.binder.kafka.streams.GlobalKTableBinder;
import org.springframework.cloud.stream.binder.kafka.streams.KafkaStreamsBinderHealthIndicatorConfiguration;
import org.springframework.cloud.stream.binder.kafka.streams.KafkaStreamsBindingInformationCatalogue;
import org.springframework.cloud.stream.binder.kafka.streams.KafkaStreamsJaasConfiguration;
import org.springframework.cloud.stream.binder.kafka.streams.KafkaStreamsRegistry;
import org.springframework.cloud.stream.binder.kafka.streams.MultiBinderPropertiesConfiguration;
import org.springframework.cloud.stream.binder.kafka.streams.properties.KafkaStreamsBinderConfigurationProperties;
import org.springframework.cloud.stream.binder.kafka.streams.properties.KafkaStreamsExtendedBindingProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={KafkaAutoConfiguration.class, MultiBinderPropertiesConfiguration.class, KafkaStreamsBinderHealthIndicatorConfiguration.class, KafkaStreamsJaasConfiguration.class})
public class GlobalKTableBinderConfiguration {
    @Bean
    public KafkaTopicProvisioner provisioningProvider(KafkaStreamsBinderConfigurationProperties binderConfigurationProperties, KafkaProperties kafkaProperties, ObjectProvider<AdminClientConfigCustomizer> adminClientConfigCustomizer) {
        return new KafkaTopicProvisioner((KafkaBinderConfigurationProperties)binderConfigurationProperties, kafkaProperties, (AdminClientConfigCustomizer)adminClientConfigCustomizer.getIfUnique());
    }

    @Bean
    public GlobalKTableBinder GlobalKTableBinder(KafkaStreamsBinderConfigurationProperties binderConfigurationProperties, KafkaTopicProvisioner kafkaTopicProvisioner, KafkaStreamsExtendedBindingProperties kafkaStreamsExtendedBindingProperties, KafkaStreamsBindingInformationCatalogue kafkaStreamsBindingInformationCatalogue, @Qualifier(value="streamConfigGlobalProperties") Map<String, Object> streamConfigGlobalProperties) {
        GlobalKTableBinder globalKTableBinder = new GlobalKTableBinder(binderConfigurationProperties, kafkaTopicProvisioner, kafkaStreamsBindingInformationCatalogue);
        globalKTableBinder.setKafkaStreamsExtendedBindingProperties(kafkaStreamsExtendedBindingProperties);
        return globalKTableBinder;
    }

    @Bean
    @ConditionalOnBean(name={"outerContext"})
    public static BeanFactoryPostProcessor outerContextBeanFactoryPostProcessor() {
        return beanFactory -> {
            ApplicationContext outerContext = (ApplicationContext)beanFactory.getBean("outerContext");
            beanFactory.registerSingleton(KafkaStreamsExtendedBindingProperties.class.getSimpleName(), outerContext.getBean(KafkaStreamsExtendedBindingProperties.class));
            beanFactory.registerSingleton(KafkaStreamsBindingInformationCatalogue.class.getSimpleName(), outerContext.getBean(KafkaStreamsBindingInformationCatalogue.class));
            beanFactory.registerSingleton(KafkaStreamsRegistry.class.getSimpleName(), outerContext.getBean(KafkaStreamsRegistry.class));
        };
    }
}

