/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka.streams;

import java.util.Map;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.kafka.KafkaAutoConfiguration;
import org.springframework.boot.autoconfigure.kafka.KafkaProperties;
import org.springframework.cloud.stream.binder.kafka.properties.KafkaBinderConfigurationProperties;
import org.springframework.cloud.stream.binder.kafka.provisioning.KafkaTopicProvisioner;
import org.springframework.cloud.stream.binder.kafka.streams.KTableBinder;
import org.springframework.cloud.stream.binder.kafka.streams.KafkaStreamsBinderHealthIndicatorConfiguration;
import org.springframework.cloud.stream.binder.kafka.streams.MutliBinderPropertiesConfiguration;
import org.springframework.cloud.stream.binder.kafka.streams.properties.KafkaStreamsBinderConfigurationProperties;
import org.springframework.cloud.stream.binder.kafka.streams.properties.KafkaStreamsExtendedBindingProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={KafkaAutoConfiguration.class, KafkaStreamsBinderHealthIndicatorConfiguration.class, MutliBinderPropertiesConfiguration.class})
public class KTableBinderConfiguration {
    @Bean
    public KafkaTopicProvisioner provisioningProvider(KafkaStreamsBinderConfigurationProperties binderConfigurationProperties, KafkaProperties kafkaProperties) {
        return new KafkaTopicProvisioner((KafkaBinderConfigurationProperties)binderConfigurationProperties, kafkaProperties);
    }

    @Bean
    public KTableBinder kTableBinder(KafkaStreamsBinderConfigurationProperties binderConfigurationProperties, KafkaTopicProvisioner kafkaTopicProvisioner, KafkaStreamsExtendedBindingProperties kafkaStreamsExtendedBindingProperties, @Qualifier(value="streamConfigGlobalProperties") Map<String, Object> streamConfigGlobalProperties) {
        KTableBinder kTableBinder = new KTableBinder(binderConfigurationProperties, kafkaTopicProvisioner);
        kTableBinder.setKafkaStreamsExtendedBindingProperties(kafkaStreamsExtendedBindingProperties);
        return kTableBinder;
    }

    @Bean
    @ConditionalOnBean(name={"outerContext"})
    public static BeanFactoryPostProcessor outerContextBeanFactoryPostProcessor() {
        return beanFactory -> {
            ApplicationContext outerContext = (ApplicationContext)beanFactory.getBean("outerContext");
            beanFactory.registerSingleton(KafkaStreamsExtendedBindingProperties.class.getSimpleName(), outerContext.getBean(KafkaStreamsExtendedBindingProperties.class));
        };
    }
}

